/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.graph;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.ImmutableList;
import dev.mccue.guava.graph.DirectedMultiNetworkConnections;
import dev.mccue.guava.graph.DirectedNetworkConnections;
import dev.mccue.guava.graph.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.graph.EndpointPair;
import dev.mccue.guava.graph.MutableNetwork;
import dev.mccue.guava.graph.NetworkBuilder;
import dev.mccue.guava.graph.NetworkConnections;
import dev.mccue.guava.graph.StandardNetwork;
import dev.mccue.guava.graph.UndirectedMultiNetworkConnections;
import dev.mccue.guava.graph.UndirectedNetworkConnections;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
final class StandardMutableNetwork<N, E>
extends StandardNetwork<N, E>
implements MutableNetwork<N, E> {
    StandardMutableNetwork(NetworkBuilder<? super N, ? super E> builder) {
        super(builder);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        if (this.containsNode(node)) {
            return false;
        }
        this.addNodeInternal(node);
        return true;
    }

    @CanIgnoreReturnValue
    private NetworkConnections<N, E> addNodeInternal(N node) {
        NetworkConnections<N, E> connections = this.newConnections();
        Preconditions.checkState((this.nodeConnections.put(node, connections) == null ? 1 : 0) != 0);
        return connections;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(N nodeU, N nodeV, E edge) {
        Preconditions.checkNotNull(nodeU, (Object)"nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"nodeV");
        Preconditions.checkNotNull(edge, (Object)"edge");
        if (this.containsEdge(edge)) {
            EndpointPair existingIncidentNodes = this.incidentNodes(edge);
            EndpointPair<N> newIncidentNodes = EndpointPair.of(this, nodeU, nodeV);
            Preconditions.checkArgument((boolean)existingIncidentNodes.equals(newIncidentNodes), (String)"Edge %s already exists between the following nodes: %s, so it cannot be reused to connect the following nodes: %s.", edge, existingIncidentNodes, newIncidentNodes);
            return false;
        }
        NetworkConnections<N, E> connectionsU = (NetworkConnections<N, E>)this.nodeConnections.get(nodeU);
        if (!this.allowsParallelEdges()) {
            Preconditions.checkArgument((connectionsU == null || !connectionsU.successors().contains(nodeV) ? 1 : 0) != 0, (String)"Nodes %s and %s are already connected by a different edge. To construct a graph that allows parallel edges, call allowsParallelEdges(true) on the Builder.", nodeU, nodeV);
        }
        boolean isSelfLoop = nodeU.equals(nodeV);
        if (!this.allowsSelfLoops()) {
            Preconditions.checkArgument((!isSelfLoop ? 1 : 0) != 0, (String)"Cannot add self-loop edge on node %s, as self-loops are not allowed. To construct a graph that allows self-loops, call allowsSelfLoops(true) on the Builder.", nodeU);
        }
        if (connectionsU == null) {
            connectionsU = this.addNodeInternal(nodeU);
        }
        connectionsU.addOutEdge(edge, nodeV);
        NetworkConnections<N, E> connectionsV = (NetworkConnections<N, E>)this.nodeConnections.get(nodeV);
        if (connectionsV == null) {
            connectionsV = this.addNodeInternal(nodeV);
        }
        connectionsV.addInEdge(edge, nodeU, isSelfLoop);
        this.edgeToReferenceNode.put(edge, nodeU);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addEdge(EndpointPair<N> endpoints, E edge) {
        this.validateEndpoints(endpoints);
        return this.addEdge(endpoints.nodeU(), endpoints.nodeV(), edge);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeNode(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        NetworkConnections connections = (NetworkConnections)this.nodeConnections.get(node);
        if (connections == null) {
            return false;
        }
        for (Object edge : ImmutableList.copyOf(connections.incidentEdges())) {
            this.removeEdge(edge);
        }
        this.nodeConnections.remove(node);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeEdge(E edge) {
        Preconditions.checkNotNull(edge, (Object)"edge");
        Object nodeU = this.edgeToReferenceNode.get(edge);
        if (nodeU == null) {
            return false;
        }
        NetworkConnections connectionsU = Objects.requireNonNull((NetworkConnections)this.nodeConnections.get(nodeU));
        Object nodeV = connectionsU.adjacentNode(edge);
        NetworkConnections connectionsV = Objects.requireNonNull((NetworkConnections)this.nodeConnections.get(nodeV));
        connectionsU.removeOutEdge(edge);
        connectionsV.removeInEdge(edge, this.allowsSelfLoops() && nodeU.equals(nodeV));
        this.edgeToReferenceNode.remove(edge);
        return true;
    }

    private NetworkConnections<N, E> newConnections() {
        return this.isDirected() ? (this.allowsParallelEdges() ? DirectedMultiNetworkConnections.of() : DirectedNetworkConnections.of()) : (this.allowsParallelEdges() ? UndirectedMultiNetworkConnections.of() : UndirectedNetworkConnections.of());
    }
}

