/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.graph;

import com.google.errorprone.annotations.Immutable;
import dev.mccue.guava.base.MoreObjects;
import dev.mccue.guava.base.Objects;
import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.collect.Maps;
import dev.mccue.guava.collect.Ordering;
import dev.mccue.guava.graph.ElementTypesAreNonnullByDefault;
import dev.mccue.jsr305.CheckForNull;
import java.util.Comparator;
import java.util.Map;

@Immutable
@ElementTypesAreNonnullByDefault
public final class ElementOrder<T> {
    private final Type type;
    @CheckForNull
    private final Comparator<T> comparator;

    private ElementOrder(Type type, @CheckForNull Comparator<T> comparator) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.comparator = comparator;
        Preconditions.checkState((type == Type.SORTED == (comparator != null) ? 1 : 0) != 0);
    }

    public static <S> ElementOrder<S> unordered() {
        return new ElementOrder(Type.UNORDERED, null);
    }

    public static <S> ElementOrder<S> stable() {
        return new ElementOrder(Type.STABLE, null);
    }

    public static <S> ElementOrder<S> insertion() {
        return new ElementOrder(Type.INSERTION, null);
    }

    public static <S extends Comparable<? super S>> ElementOrder<S> natural() {
        return new ElementOrder(Type.SORTED, Ordering.natural());
    }

    public static <S> ElementOrder<S> sorted(Comparator<S> comparator) {
        return new ElementOrder(Type.SORTED, (Comparator)Preconditions.checkNotNull(comparator));
    }

    public Type type() {
        return this.type;
    }

    public Comparator<T> comparator() {
        if (this.comparator != null) {
            return this.comparator;
        }
        throw new UnsupportedOperationException("This ordering does not define a comparator.");
    }

    public boolean equals(@CheckForNull Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ElementOrder)) {
            return false;
        }
        ElementOrder other = (ElementOrder)obj;
        return this.type == other.type && Objects.equal(this.comparator, other.comparator);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.comparator});
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type);
        if (this.comparator != null) {
            helper.add("comparator", this.comparator);
        }
        return helper.toString();
    }

    <K extends T, V> Map<K, V> createMap(int expectedSize) {
        switch (this.type) {
            case UNORDERED: {
                return Maps.newHashMapWithExpectedSize((int)expectedSize);
            }
            case INSERTION: 
            case STABLE: {
                return Maps.newLinkedHashMapWithExpectedSize((int)expectedSize);
            }
            case SORTED: {
                return Maps.newTreeMap(this.comparator());
            }
        }
        throw new AssertionError();
    }

    <T1 extends T> ElementOrder<T1> cast() {
        return this;
    }

    public static enum Type {
        UNORDERED,
        STABLE,
        INSERTION,
        SORTED;

    }
}

