/*
 * Decompiled with CFR 0.152.
 */
package dev.mccue.guava.graph;

import dev.mccue.guava.base.Preconditions;
import dev.mccue.guava.base.Supplier;
import dev.mccue.guava.collect.ImmutableSet;
import dev.mccue.guava.collect.Iterators;
import dev.mccue.guava.collect.Sets;
import dev.mccue.guava.collect.UnmodifiableIterator;
import dev.mccue.guava.graph.BaseGraph;
import dev.mccue.guava.graph.ElementOrder;
import dev.mccue.guava.graph.ElementTypesAreNonnullByDefault;
import dev.mccue.guava.graph.EndpointPair;
import dev.mccue.guava.graph.EndpointPairIterator;
import dev.mccue.guava.graph.IncidentEdgeSet;
import dev.mccue.guava.graph.InvalidatableSet;
import dev.mccue.guava.math.IntMath;
import dev.mccue.guava.primitives.Ints;
import dev.mccue.jsr305.CheckForNull;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class AbstractBaseGraph<N>
implements BaseGraph<N> {
    AbstractBaseGraph() {
    }

    protected long edgeCount() {
        long degreeSum = 0L;
        for (Object node : this.nodes()) {
            degreeSum += (long)this.degree(node);
        }
        Preconditions.checkState(((degreeSum & 1L) == 0L ? 1 : 0) != 0);
        return degreeSum >>> 1;
    }

    @Override
    public Set<EndpointPair<N>> edges() {
        return new AbstractSet<EndpointPair<N>>(){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                return EndpointPairIterator.of(AbstractBaseGraph.this);
            }

            @Override
            public int size() {
                return Ints.saturatedCast((long)AbstractBaseGraph.this.edgeCount());
            }

            @Override
            public boolean remove(@CheckForNull Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(@CheckForNull Object obj) {
                if (!(obj instanceof EndpointPair)) {
                    return false;
                }
                EndpointPair endpointPair = (EndpointPair)obj;
                return AbstractBaseGraph.this.isOrderingCompatible(endpointPair) && AbstractBaseGraph.this.nodes().contains(endpointPair.nodeU()) && AbstractBaseGraph.this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
            }
        };
    }

    @Override
    public ElementOrder<N> incidentEdgeOrder() {
        return ElementOrder.unordered();
    }

    @Override
    public Set<EndpointPair<N>> incidentEdges(N node) {
        Preconditions.checkNotNull(node);
        Preconditions.checkArgument((boolean)this.nodes().contains(node), (String)"Node %s is not an element of this graph.", node);
        IncidentEdgeSet incident = new IncidentEdgeSet<N>(this, node){

            @Override
            public UnmodifiableIterator<EndpointPair<N>> iterator() {
                if (this.graph.isDirected()) {
                    return Iterators.unmodifiableIterator((Iterator)Iterators.concat((Iterator)Iterators.transform(this.graph.predecessors(this.node).iterator(), predecessor -> EndpointPair.ordered(predecessor, this.node)), (Iterator)Iterators.transform((Iterator)Sets.difference((Set)this.graph.successors(this.node), (Set)ImmutableSet.of((Object)this.node)).iterator(), successor -> EndpointPair.ordered(this.node, successor))));
                }
                return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.graph.adjacentNodes(this.node).iterator(), adjacentNode -> EndpointPair.unordered(this.node, adjacentNode)));
            }
        };
        return this.nodeInvalidatableSet(incident, node);
    }

    @Override
    public int degree(N node) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd((int)this.predecessors((Object)node).size(), (int)this.successors((Object)node).size());
        }
        Set<N> neighbors = this.adjacentNodes(node);
        int selfLoopCount = this.allowsSelfLoops() && neighbors.contains(node) ? 1 : 0;
        return IntMath.saturatedAdd((int)neighbors.size(), (int)selfLoopCount);
    }

    @Override
    public int inDegree(N node) {
        return this.isDirected() ? this.predecessors((Object)node).size() : this.degree(node);
    }

    @Override
    public int outDegree(N node) {
        return this.isDirected() ? this.successors((Object)node).size() : this.degree(node);
    }

    @Override
    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        Preconditions.checkNotNull(nodeU);
        Preconditions.checkNotNull(nodeV);
        return this.nodes().contains(nodeU) && this.successors((Object)nodeU).contains(nodeV);
    }

    @Override
    public boolean hasEdgeConnecting(EndpointPair<N> endpoints) {
        Preconditions.checkNotNull(endpoints);
        if (!this.isOrderingCompatible(endpoints)) {
            return false;
        }
        N nodeU = endpoints.nodeU();
        N nodeV = endpoints.nodeV();
        return this.nodes().contains(nodeU) && this.successors((Object)nodeU).contains(nodeV);
    }

    protected final void validateEndpoints(EndpointPair<?> endpoints) {
        Preconditions.checkNotNull(endpoints);
        Preconditions.checkArgument((boolean)this.isOrderingCompatible(endpoints), (Object)"Mismatch: endpoints' ordering is not compatible with directionality of the graph");
    }

    protected final boolean isOrderingCompatible(EndpointPair<?> endpoints) {
        return endpoints.isOrdered() == this.isDirected();
    }

    protected final <T> Set<T> nodeInvalidatableSet(Set<T> set, N node) {
        return InvalidatableSet.of(set, (Supplier<Boolean>)((Supplier)() -> this.nodes().contains(node)), (Supplier<String>)((Supplier)() -> String.format("Node %s that was used to generate this set is no longer in the graph.", node)));
    }

    protected final <T> Set<T> nodePairInvalidatableSet(Set<T> set, N nodeU, N nodeV) {
        return InvalidatableSet.of(set, (Supplier<Boolean>)((Supplier)() -> this.nodes().contains(nodeU) && this.nodes().contains(nodeV)), (Supplier<String>)((Supplier)() -> String.format("Node %s or node %s that were used to generate this set are no longer in the graph.", nodeU, nodeV)));
    }
}

