/*
 * Decompiled with CFR 0.152.
 */
package masecla.modrinth4j.endpoints.user;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import masecla.modrinth4j.client.HttpClient;
import masecla.modrinth4j.endpoints.generic.empty.EmptyRequest;
import masecla.modrinth4j.endpoints.generic.empty.EmptyResponse;
import masecla.modrinth4j.endpoints.user.ChangeUserIcon;
import masecla.modrinth4j.endpoints.user.DeleteUser;
import masecla.modrinth4j.endpoints.user.GetSelf;
import masecla.modrinth4j.endpoints.user.GetUser;
import masecla.modrinth4j.endpoints.user.GetUserFollowedProjects;
import masecla.modrinth4j.endpoints.user.GetUserNotifications;
import masecla.modrinth4j.endpoints.user.GetUserProjects;
import masecla.modrinth4j.endpoints.user.GetUsers;
import masecla.modrinth4j.endpoints.user.ModifyUser;
import masecla.modrinth4j.endpoints.user.ReportProjectUserOrVersion;
import masecla.modrinth4j.model.project.Project;
import masecla.modrinth4j.model.user.ModrinthUser;
import masecla.modrinth4j.model.user.ModrinthUserNotification;

public class UserEndpoints {
    private Gson gson;
    private HttpClient client;

    public CompletableFuture<ModrinthUser> getUser(String id) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new GetUser(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<List<ModrinthUser>> getUser(String ... ids) {
        return this.getUser(Arrays.asList(ids));
    }

    public CompletableFuture<List<ModrinthUser>> getUser(List<String> ids) {
        return new GetUsers(this.client, this.gson).sendRequest(new GetUsers.GetUsersRequest(ids));
    }

    public CompletableFuture<EmptyResponse> modifyUser(String id, ModifyUser.ModifyUserRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new ModifyUser(this.client, this.gson).sendRequest(request, parameters);
    }

    public CompletableFuture<EmptyResponse> deleteUser(String id) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new DeleteUser(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<ModrinthUser> getSelf() {
        return new GetSelf(this.client, this.gson).sendRequest(new EmptyRequest(), new HashMap<String, String>());
    }

    public CompletableFuture<EmptyResponse> changeProfilePicture(String id, File file) throws FileNotFoundException {
        return this.changeProfilePicture(id, new FileInputStream(file), file.getName());
    }

    public CompletableFuture<EmptyResponse> changeProfilePicture(String id, InputStream stream, String filename) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new ChangeUserIcon(this.client, this.gson).sendRequest(new ChangeUserIcon.ChangeUserIconRequest(filename, stream), (Map<String, String>)parameters);
    }

    public CompletableFuture<List<Project>> getUserProjects(String id) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new GetUserProjects(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<List<Project>> getUserFollowedProjects(String id) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new GetUserFollowedProjects(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<List<ModrinthUserNotification>> getNotifications(String id) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", id);
        return new GetUserNotifications(this.client, this.gson).sendRequest(new EmptyRequest(), parameters);
    }

    public CompletableFuture<ReportProjectUserOrVersion.ReportProjectUserOrVersionResponse> reportProjectUserOrVersion(ReportProjectUserOrVersion.ReportProjectUserOrVersionRequest request) {
        return new ReportProjectUserOrVersion(this.client, this.gson).sendRequest(request);
    }

    @Generated
    public UserEndpoints(Gson gson, HttpClient client) {
        this.gson = gson;
        this.client = client;
    }
}

