/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.blas;

import dev.ludovic.netlib.NativeBLAS;
import dev.ludovic.netlib.blas.AbstractBLAS;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermissions;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;

public final class JNIBLAS
extends AbstractBLAS
implements NativeBLAS {
    private static final JNIBLAS instance = new JNIBLAS();

    protected JNIBLAS() {
        Path temp;
        String osName = System.getProperty("os.name");
        if (osName == null || osName.isEmpty()) {
            throw new RuntimeException("Unable to load native implementation");
        }
        String osArch = System.getProperty("os.arch");
        if (osArch == null || osArch.isEmpty()) {
            throw new RuntimeException("Unable to load native implementation");
        }
        try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream(String.format("resources/native/%s-%s/libnetlibblasjni.so", osName, osArch));){
            assert (resource != null);
            temp = Files.createTempFile("libnetlibblasjni.so", "", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
            Files.copy(resource, temp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load native implementation", e);
        }
        System.load(temp.toString());
    }

    public static NativeBLAS getInstance() {
        return instance;
    }

    @Override
    protected native double dasumK(int var1, double[] var2, int var3, int var4);

    @Override
    protected native float sasumK(int var1, float[] var2, int var3, int var4);

    @Override
    protected native void daxpyK(int var1, double var2, double[] var4, int var5, int var6, double[] var7, int var8, int var9);

    @Override
    protected native void saxpyK(int var1, float var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8);

    @Override
    protected native void dcopyK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    @Override
    protected native void scopyK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    @Override
    protected native double ddotK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    @Override
    protected native float sdotK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    @Override
    protected native float sdsdotK(int var1, float var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8);

    @Override
    protected native void dgbmvK(String var1, int var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18);

    @Override
    protected native void sgbmvK(String var1, int var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16);

    @Override
    protected native void dgemmK(String var1, String var2, int var3, int var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double var14, double[] var16, int var17, int var18);

    @Override
    protected native void sgemmK(String var1, String var2, int var3, int var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float[] var14, int var15, int var16);

    @Override
    protected native void dgemvK(String var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16);

    @Override
    protected native void sgemvK(String var1, int var2, int var3, float var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float var11, float[] var12, int var13, int var14);

    @Override
    protected native void dgerK(int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    @Override
    protected native void sgerK(int var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12);

    @Override
    protected native double dnrm2K(int var1, double[] var2, int var3, int var4);

    @Override
    protected native float snrm2K(int var1, float[] var2, int var3, int var4);

    @Override
    protected native void drotK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double var8, double var10);

    @Override
    protected native void srotK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, float var8, float var9);

    @Override
    protected native void drotmK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9);

    @Override
    protected native void srotmK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9);

    @Override
    protected native void drotmgK(doubleW var1, doubleW var2, doubleW var3, double var4, double[] var6, int var7);

    @Override
    protected native void srotmgK(floatW var1, floatW var2, floatW var3, float var4, float[] var5, int var6);

    @Override
    protected native void dsbmvK(String var1, int var2, int var3, double var4, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double[] var14, int var15, int var16);

    @Override
    protected native void ssbmvK(String var1, int var2, int var3, float var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float var11, float[] var12, int var13, int var14);

    @Override
    protected native void dscalK(int var1, double var2, double[] var4, int var5, int var6);

    @Override
    protected native void sscalK(int var1, float var2, float[] var3, int var4, int var5);

    @Override
    protected native void dspmvK(String var1, int var2, double var3, double[] var5, int var6, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14);

    @Override
    protected native void sspmvK(String var1, int var2, float var3, float[] var4, int var5, float[] var6, int var7, int var8, float var9, float[] var10, int var11, int var12);

    @Override
    protected native void dsprK(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9);

    @Override
    protected native void ssprK(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8);

    @Override
    protected native void dspr2K(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12);

    @Override
    protected native void sspr2K(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11);

    @Override
    protected native void dswapK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    @Override
    protected native void sswapK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    @Override
    protected native void dsymmK(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    @Override
    protected native void ssymmK(String var1, String var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float[] var13, int var14, int var15);

    @Override
    protected native void dsymvK(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double var11, double[] var13, int var14, int var15);

    @Override
    protected native void ssymvK(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float var10, float[] var11, int var12, int var13);

    @Override
    protected native void dsyrK(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    protected native void ssyrK(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9);

    @Override
    protected native void dsyr2K(String var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    @Override
    protected native void ssyr2K(String var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12);

    @Override
    protected native void dsyr2kK(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    @Override
    protected native void ssyr2kK(String var1, String var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float[] var13, int var14, int var15);

    @Override
    protected native void dsyrkK(String var1, String var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double var10, double[] var12, int var13, int var14);

    @Override
    protected native void ssyrkK(String var1, String var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float var9, float[] var10, int var11, int var12);

    @Override
    protected native void dtbmvK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    @Override
    protected native void stbmvK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    @Override
    protected native void dtbsvK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    @Override
    protected native void stbsvK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    @Override
    protected native void dtpmvK(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    @Override
    protected native void stpmvK(String var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9);

    @Override
    protected native void dtpsvK(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    @Override
    protected native void stpsvK(String var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9);

    @Override
    protected native void dtrmmK(String var1, String var2, String var3, String var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    @Override
    protected native void strmmK(String var1, String var2, String var3, String var4, int var5, int var6, float var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13);

    @Override
    protected native void dtrmvK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    protected native void strmvK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10);

    @Override
    protected native void dtrsmK(String var1, String var2, String var3, String var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    @Override
    protected native void strsmK(String var1, String var2, String var3, String var4, int var5, int var6, float var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13);

    @Override
    protected native void dtrsvK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    protected native void strsvK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10);

    @Override
    protected native int idamaxK(int var1, double[] var2, int var3, int var4);

    @Override
    protected native int isamaxK(int var1, float[] var2, int var3, int var4);
}

