/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas;

import dev.ludovic.netlib.blas.BLAS;
import dev.ludovic.netlib.blas.JavaBLAS;
import dev.ludovic.netlib.blas.NativeBLAS;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Fork(value=1)
public abstract class BLASBenchmark {
    public BLAS blas;
    @Param(value={"java", "native"})
    public String implementation;
    private final Random rand = new Random(0L);

    @Setup
    public void setupImplementation() {
        switch (this.implementation) {
            case "java": {
                this.blas = JavaBLAS.getInstance();
                break;
            }
            case "native": {
                this.blas = NativeBLAS.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown implementation = " + this.implementation);
            }
        }
        System.out.println("implementation = " + this.blas.getClass().getName());
    }

    protected double randomDouble() {
        return this.rand.nextDouble();
    }

    protected double[] randomDoubleArray(int n) {
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextDouble();
        }
        return res;
    }

    protected float randomFloat() {
        return this.rand.nextFloat();
    }

    protected float[] randomFloatArray(int n) {
        float[] res = new float[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextFloat();
        }
        return res;
    }
}

