/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.selenium;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumDocumentLoader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SeleniumDocumentLoader.class);
    private static final Duration DEFAULT_TIMEOUT_DURATION = Duration.ofSeconds(30L);
    private final WebDriver webDriver;
    private final Duration timeout;
    private ExpectedCondition<Boolean> pageReadyCondition = wd -> {
        if (logger.isTraceEnabled()) {
            logger.trace("Waiting for document.readyState to be complete");
        }
        return ((JavascriptExecutor)Objects.requireNonNull(wd)).executeScript("return document.readyState", new Object[0]).equals("complete");
    };

    private SeleniumDocumentLoader(WebDriver webDriver, Duration timeout) {
        this.webDriver = Objects.requireNonNull(webDriver, "webDriver must not be null");
        this.timeout = Objects.requireNonNull(timeout, "timeout must not be null");
    }

    public SeleniumDocumentLoader pageReadyCondition(ExpectedCondition<Boolean> condition) {
        this.pageReadyCondition = Objects.requireNonNull(condition, "pageReadyCondition must not be null");
        return this;
    }

    public Document load(String url, DocumentParser documentParser) {
        String pageContent;
        Objects.requireNonNull(url, "url must not be null");
        Objects.requireNonNull(documentParser, "documentParser must not be null");
        logger.info("Loading document from URL: {}", (Object)url);
        try {
            this.webDriver.get(url);
            WebDriverWait wait = new WebDriverWait(this.webDriver, this.timeout);
            logger.debug("Waiting webpage fully loaded: {}", (Object)url);
            wait.until(this.pageReadyCondition);
            pageContent = this.webDriver.getPageSource();
        }
        catch (Exception e) {
            logger.error("Failed to load document from URL: {}", (Object)url, (Object)e);
            throw new RuntimeException("Failed to load document from URL: " + url, e);
        }
        Document parsedDocument = documentParser.parse((InputStream)new ByteArrayInputStream(pageContent.getBytes()));
        parsedDocument.metadata().put("url", url);
        return parsedDocument;
    }

    @Override
    public void close() {
        if (this.webDriver != null) {
            try {
                this.webDriver.quit();
                logger.info("WebDriver closed successfully.");
            }
            catch (Exception e) {
                logger.warn("Error closing WebDriver", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private WebDriver webDriver;
        private Duration timeout = DEFAULT_TIMEOUT_DURATION;

        public Builder webDriver(WebDriver webDriver) {
            this.webDriver = webDriver;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public SeleniumDocumentLoader build() {
            Objects.requireNonNull(this.webDriver, "webDriver must be set");
            return new SeleniumDocumentLoader(this.webDriver, this.timeout);
        }
    }
}

