/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.loader.amazon.s3;

import dev.langchain4j.internal.ValidationUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class AwsCredentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;

    public AwsCredentials(String accessKeyId, String secretAccessKey) {
        this(accessKeyId, secretAccessKey, null);
    }

    public AwsCredentials(String accessKeyId, String secretAccessKey, String sessionToken) {
        this.accessKeyId = ValidationUtils.ensureNotBlank((String)accessKeyId, (String)"accessKeyId");
        this.secretAccessKey = ValidationUtils.ensureNotBlank((String)secretAccessKey, (String)"secretAccessKey");
        this.sessionToken = sessionToken;
    }

    public AwsCredentialsProvider toCredentialsProvider() {
        return StaticCredentialsProvider.create((software.amazon.awssdk.auth.credentials.AwsCredentials)this.toCredentials());
    }

    private software.amazon.awssdk.auth.credentials.AwsCredentials toCredentials() {
        if (this.sessionToken != null) {
            return AwsSessionCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey, (String)this.sessionToken);
        }
        return AwsBasicCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey);
    }
}

