/*
 * Decompiled with CFR 0.152.
 */
package dev.icerock.gradle;

import dev.icerock.gradle.AppleFrameworkPlugin;
import dev.icerock.gradle.FrameworkConfig;
import dev.icerock.gradle.tasks.SyncCocoaPodFrameworkTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.AbstractKotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinNativeBinaryContainer;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeLink;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Ldev/icerock/gradle/AppleFrameworkPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "configureFrameworkExports", "framework", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "frameworkConfig", "Ldev/icerock/gradle/FrameworkConfig;", "configureSyncFrameworkTasks", "targetFilter", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;", "mobile-multiplatform"})
public class AppleFrameworkPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = target.getExtensions().create("framework", FrameworkConfig.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"target.extensions.create\u2026meworkConfig::class.java)");
        FrameworkConfig frameworkExtension = (FrameworkConfig)object;
        KotlinMultiplatformExtension kotlinMultiplatformExtension = (KotlinMultiplatformExtension)target.getExtensions().findByType(KotlinMultiplatformExtension.class);
        if (kotlinMultiplatformExtension == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)kotlinMultiplatformExtension, (String)"target.extensions.findBy\u2026on::class.java) ?: return");
        KotlinMultiplatformExtension kmpExtension = kotlinMultiplatformExtension;
        NamedDomainObjectCollection $this$withType$iv = kmpExtension.getTargets();
        boolean $i$f$withType = false;
        NamedDomainObjectCollection namedDomainObjectCollection = $this$withType$iv.withType(KotlinNativeTarget.class);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectCollection, (String)"withType(S::class.java)");
        Function1 function1 = (Function1)new Function1<KotlinNativeTarget, Boolean>(this){

            public final boolean invoke(@NotNull KotlinNativeTarget p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((AppleFrameworkPlugin)this.receiver).targetFilter(p1);
            }
        };
        namedDomainObjectCollection.matching(new Spec(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ boolean isSatisfiedBy(Object p0) {
                Object object = this.function.invoke(p0);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                return (Boolean)object;
            }
        }).all(new Action(this, frameworkExtension){
            final /* synthetic */ AppleFrameworkPlugin this$0;
            final /* synthetic */ FrameworkConfig $frameworkExtension;

            public final void execute(@NotNull KotlinNativeTarget $this$all) {
                Intrinsics.checkNotNullParameter((Object)$this$all, (String)"$receiver");
                $this$all.binaries((Function1)new Function1<KotlinNativeBinaryContainer, Unit>(this){
                    final /* synthetic */ apply.2 this$0;

                    public final void invoke(@NotNull KotlinNativeBinaryContainer $this$binaries) {
                        Intrinsics.checkNotNullParameter((Object)$this$binaries, (String)"$receiver");
                        AbstractKotlinNativeBinaryContainer.framework$default((AbstractKotlinNativeBinaryContainer)((AbstractKotlinNativeBinaryContainer)$this$binaries), (String)this.this$0.$frameworkExtension.getName(), null, (Function1)((Function1)new Function1<Framework, Unit>(this){
                            final /* synthetic */ apply.1 this$0;

                            public final void invoke(@NotNull Framework $this$framework) {
                                Intrinsics.checkNotNullParameter((Object)$this$framework, (String)"$receiver");
                                AppleFrameworkPlugin.access$configureFrameworkExports(this.this$0.this$0.this$0, $this$framework, this.this$0.this$0.$frameworkExtension);
                                AppleFrameworkPlugin.access$configureSyncFrameworkTasks(this.this$0.this$0.this$0, $this$framework);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }), (int)2, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = appleFrameworkPlugin;
                this.$frameworkExtension = frameworkConfig;
            }
        });
    }

    protected boolean targetFilter(@NotNull KotlinNativeTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return target.getKonanTarget().getFamily().isAppleFamily();
    }

    private final void configureFrameworkExports(Framework framework, FrameworkConfig frameworkConfig) {
        Project project = framework.getProject();
        project.afterEvaluate(new Action(frameworkConfig, project, framework){
            final /* synthetic */ FrameworkConfig $frameworkConfig;
            final /* synthetic */ Project $project;
            final /* synthetic */ Framework $framework;

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$receiver");
                Iterable $this$forEach$iv = this.$frameworkConfig.getExports$mobile_multiplatform();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FrameworkConfig.ExportDeclaration exportDeclaration = (FrameworkConfig.ExportDeclaration)element$iv;
                    boolean bl = false;
                    this.$project.getLogger().info("export " + exportDeclaration);
                    exportDeclaration.export(this.$project, this.$framework);
                }
            }
            {
                this.$frameworkConfig = frameworkConfig;
                this.$project = project;
                this.$framework = framework;
            }
        });
    }

    private final void configureSyncFrameworkTasks(Framework framework) {
        KotlinNativeLink linkTask = framework.getLinkTask();
        String string = linkTask.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"linkTask.name");
        String syncTaskName = StringsKt.replaceFirst$default((String)string, (String)"link", (String)"sync", (boolean)false, (int)4, null);
        framework.getProject().getTasks().create(syncTaskName, SyncCocoaPodFrameworkTask.class, new Action(framework, linkTask){
            final /* synthetic */ Framework $framework;
            final /* synthetic */ KotlinNativeLink $linkTask;

            public final void execute(@NotNull SyncCocoaPodFrameworkTask $this$create) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$create), (String)"$receiver");
                $this$create.setInputDir(this.$framework.getOutputDirectory());
                $this$create.dependsOn(new Object[]{this.$linkTask});
            }
            {
                this.$framework = framework;
                this.$linkTask = kotlinNativeLink;
            }
        });
    }

    public static final /* synthetic */ void access$configureFrameworkExports(AppleFrameworkPlugin $this, Framework framework, FrameworkConfig frameworkConfig) {
        $this.configureFrameworkExports(framework, frameworkConfig);
    }

    public static final /* synthetic */ void access$configureSyncFrameworkTasks(AppleFrameworkPlugin $this, Framework framework) {
        $this.configureSyncFrameworkTasks(framework);
    }
}

