/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.nonnull;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.models.AnnotatedAbstractModel;
import dev.hilla.parser.models.AnnotatedModel;
import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.SpecializedModel;
import dev.hilla.parser.plugins.backbone.BackbonePlugin;
import dev.hilla.parser.plugins.backbone.nodes.AnnotatedNode;
import dev.hilla.parser.plugins.backbone.nodes.MethodNode;
import dev.hilla.parser.plugins.backbone.nodes.MethodParameterNode;
import dev.hilla.parser.plugins.backbone.nodes.PropertyNode;
import dev.hilla.parser.plugins.backbone.nodes.TypedNode;
import dev.hilla.parser.plugins.nonnull.AnnotationMatcher;
import dev.hilla.parser.plugins.nonnull.NonnullPluginConfig;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class NonnullPlugin
extends AbstractPlugin<NonnullPluginConfig> {
    private Map<String, AnnotationMatcher> annotationsMap = NonnullPlugin.mapByName(NonnullPluginConfig.Processor.defaults);

    private static Map<String, AnnotationMatcher> mapByName(Collection<AnnotationMatcher> annotations) {
        return annotations.stream().collect(Collectors.toMap(AnnotationMatcher::getName, Function.identity()));
    }

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
        Node node = nodePath.getNode();
        if (node.getTarget() instanceof Schema) {
            Schema schema = (Schema)node.getTarget();
            Object nodeSource = node.getSource();
            if (nodeSource instanceof SpecializedModel && ((SpecializedModel)nodeSource).isOptional()) {
                schema.setNullable(Boolean.valueOf(true));
            } else {
                Stream<AnnotationInfoModel> annotations = this.getPackageAnnotationsStream(nodePath);
                if (node instanceof AnnotatedNode) {
                    annotations = Stream.concat(annotations, ((AnnotatedNode)node).getAnnotations().stream());
                }
                annotations = this.considerAscendantAnnotations(annotations, nodePath);
                annotations.map(annotation -> this.annotationsMap.get(annotation.getName())).filter(Objects::nonNull).max(Comparator.comparingInt(AnnotationMatcher::getScore)).map(AnnotationMatcher::doesMakeNullable).ifPresent(nullable -> schema.setNullable(nullable != false ? Boolean.valueOf(true) : null));
            }
        }
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    public void setConfiguration(@Nonnull PluginConfiguration configuration) {
        super.setConfiguration(configuration);
        this.annotationsMap = NonnullPlugin.mapByName(new NonnullPluginConfig.Processor((NonnullPluginConfig)this.getConfiguration()).process());
    }

    private Optional<ClassInfoModel> findClosestClass(NodePath<?> nodePath) {
        return nodePath.stream().map(NodePath::getNode).filter(node -> node.getSource() instanceof ClassInfoModel).map(node -> (ClassInfoModel)node.getSource()).findFirst();
    }

    private Stream<AnnotationInfoModel> getPackageAnnotationsStream(NodePath<?> nodePath) {
        return this.findClosestClass(nodePath).map(ClassInfoModel::findAncestors).map(Collection::stream).orElseGet(Stream::empty).map(AnnotatedAbstractModel::getAnnotations).flatMap(Collection::stream);
    }

    private Stream<AnnotationInfoModel> considerAscendantAnnotations(Stream<AnnotationInfoModel> annotations, NodePath<?> nodePath) {
        Node current = nodePath.getNode();
        Node parent = nodePath.getParentPath().getNode();
        if (current instanceof TypedNode && (parent instanceof MethodNode || parent instanceof MethodParameterNode || parent instanceof PropertyNode)) {
            annotations = Stream.concat(annotations, ((AnnotatedModel)parent.getSource()).getAnnotations().stream());
        }
        return annotations;
    }
}

