/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.backbone;

import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.RootNode;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.plugins.backbone.BackbonePluginConfiguration;
import dev.hilla.parser.plugins.backbone.nodes.EndpointExposedNode;
import dev.hilla.parser.plugins.backbone.nodes.EndpointNode;
import dev.hilla.parser.plugins.backbone.nodes.MethodNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class MethodPlugin
extends AbstractPlugin<BackbonePluginConfiguration> {
    public static final String MEDIA_TYPE = "application/json";

    public void enter(NodePath<?> nodePath) {
        if (!(nodePath.getNode() instanceof MethodNode)) {
            return;
        }
        MethodNode methodNode = (MethodNode)nodePath.getNode();
        Optional<Node<?, ?>> endpointParent = this.findClosestEndpoint(nodePath);
        if (endpointParent.isEmpty()) {
            return;
        }
        EndpointNode endpointNode = (EndpointNode)endpointParent.get();
        ((PathItem)methodNode.getTarget()).post(this.createOperation(endpointNode, methodNode));
    }

    public void exit(NodePath<?> nodePath) {
        if (!(nodePath.getNode() instanceof MethodNode)) {
            return;
        }
        MethodNode methodNode = (MethodNode)nodePath.getNode();
        Optional<Node<?, ?>> endpointParent = this.findClosestEndpoint(nodePath);
        if (endpointParent.isEmpty()) {
            return;
        }
        EndpointNode endpointNode = (EndpointNode)endpointParent.get();
        String endpointName = ((Tag)endpointNode.getTarget()).getName();
        String methodName = ((MethodInfoModel)methodNode.getSource()).getName();
        RootNode rootNode = (RootNode)nodePath.getRootPath().getNode();
        ((OpenAPI)rootNode.getTarget()).path("/" + endpointName + "/" + methodName, (PathItem)methodNode.getTarget());
        ((Tag)endpointNode.getTarget()).addExtension("x-class-name", (Object)((ClassInfoModel)endpointNode.getSource()).getName());
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        Node node = nodeDependencies.getNode();
        if (node instanceof EndpointNode || node instanceof EndpointExposedNode) {
            ClassInfoModel endpointCls = (ClassInfoModel)node.getSource();
            Stream<Node> methodNodes = endpointCls.getMethods().stream().filter(MethodInfoModel::isPublic).map(MethodNode::of);
            return nodeDependencies.appendChildNodes(methodNodes);
        }
        return nodeDependencies;
    }

    private Operation createOperation(EndpointNode endpointNode, MethodNode methodNode) {
        Operation operation = new Operation();
        String endpointName = ((Tag)endpointNode.getTarget()).getName();
        operation.operationId(String.format("%s_%s_POST", endpointName, ((MethodInfoModel)methodNode.getSource()).getName())).addTagsItem(endpointName).responses(this.createResponses());
        return operation;
    }

    private ApiResponses createResponses() {
        ApiResponse response = new ApiResponse().description("");
        return new ApiResponses().addApiResponse("200", response);
    }

    private Optional<Node<?, ?>> findClosestEndpoint(NodePath<?> nodePath) {
        return nodePath.getParentPath().stream().map(NodePath::getNode).filter(n -> n instanceof EndpointNode).findFirst();
    }
}

