/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.FieldInfoModel;
import dev.hilla.parser.models.MethodInfoModel;
import dev.hilla.parser.models.PackageInfoModel;
import dev.hilla.parser.models.SourceModel;
import dev.hilla.parser.models.TypeParameterModel;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefTypeSignature;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class ClassInfoSourceModel
extends ClassInfoModel
implements SourceModel {
    private final ClassInfo origin;

    ClassInfoSourceModel(ClassInfo origin) {
        this.origin = origin;
    }

    @Override
    public Object get() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public String getSimpleName() {
        return this.origin.getSimpleName();
    }

    @Override
    public boolean isAbstract() {
        return this.origin.isAbstract() || this.origin.isArrayClass();
    }

    @Override
    public boolean isAnnotation() {
        return this.origin.isAnnotation();
    }

    @Override
    public boolean isArrayClass() {
        return this.origin.isArrayClass();
    }

    @Override
    public boolean isBigDecimal() {
        return ClassInfoModel.isAssignableFrom(BigDecimal.class, this.origin);
    }

    @Override
    public boolean isBigInteger() {
        return ClassInfoModel.isAssignableFrom(BigInteger.class, this.origin);
    }

    @Override
    public boolean isBoolean() {
        return ClassInfoModel.isAssignableFrom(Boolean.class, this.origin);
    }

    @Override
    public boolean isByte() {
        return ClassInfoModel.isAssignableFrom(Byte.class, this.origin);
    }

    @Override
    public boolean isCharacter() {
        return ClassInfoModel.isAssignableFrom(Character.class, this.origin);
    }

    @Override
    public boolean isDate() {
        return ClassInfoSourceModel.isDateAssignable(this.origin, ClassInfoModel::isAssignableFrom);
    }

    @Override
    public boolean isDateTime() {
        return ClassInfoSourceModel.isDateTimeAssignable(this.origin, ClassInfoModel::isAssignableFrom);
    }

    @Override
    public boolean isDouble() {
        return ClassInfoModel.isAssignableFrom(Double.class, this.origin);
    }

    @Override
    public boolean isEnum() {
        return this.origin.isEnum();
    }

    @Override
    public boolean isFinal() {
        return this.origin.isFinal() || this.origin.isArrayClass();
    }

    @Override
    public boolean isFloat() {
        return ClassInfoModel.isAssignableFrom(Float.class, this.origin);
    }

    @Override
    public boolean isInteger() {
        return ClassInfoModel.isAssignableFrom(Integer.class, this.origin);
    }

    @Override
    public boolean isInterface() {
        return this.origin.isInterface();
    }

    @Override
    public boolean isInterfaceOrAnnotation() {
        return this.origin.isInterfaceOrAnnotation();
    }

    @Override
    public boolean isIterable() {
        return ClassInfoModel.isAssignableFrom(Iterable.class, this.origin);
    }

    @Override
    public boolean isJDKClass() {
        return ClassInfoModel.isJDKClass(this.origin);
    }

    @Override
    public boolean isLong() {
        return ClassInfoModel.isAssignableFrom(Long.class, this.origin);
    }

    @Override
    public boolean isMap() {
        return ClassInfoModel.isAssignableFrom(Map.class, this.origin);
    }

    @Override
    public boolean isNativeObject() {
        return ClassInfoModel.is(this.origin, Object.class);
    }

    @Override
    public boolean isOptional() {
        return ClassInfoModel.isAssignableFrom(Optional.class, this.origin);
    }

    @Override
    public boolean isPrivate() {
        return this.origin.isPrivate();
    }

    @Override
    public boolean isProtected() {
        return this.origin.isProtected();
    }

    @Override
    public boolean isPublic() {
        return this.origin.isPublic() && !this.origin.isProtected() || this.origin.isArrayClass();
    }

    @Override
    public boolean isShort() {
        return ClassInfoModel.isAssignableFrom(Short.class, this.origin);
    }

    @Override
    public boolean isStandardClass() {
        return this.origin.isStandardClass();
    }

    @Override
    public boolean isStatic() {
        return this.origin.isStatic();
    }

    @Override
    public boolean isString() {
        return ClassInfoModel.isAssignableFrom(String.class, this.origin);
    }

    @Override
    public boolean isSynthetic() {
        return this.origin.isSynthetic();
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return ClassInfoSourceModel.processAnnotations((List<AnnotationInfo>)this.origin.getAnnotationInfo());
    }

    @Override
    protected List<FieldInfoModel> prepareFields() {
        return this.origin.getDeclaredFieldInfo().stream().map(FieldInfoModel::of).sorted(FieldInfoModel.FIELD_ORDER).collect(Collectors.toList());
    }

    @Override
    protected List<ClassInfoModel> prepareInnerClasses() {
        return this.origin.getInnerClasses().stream().map(ClassInfoModel::of).sorted(CLASS_ORDER).collect(Collectors.toList());
    }

    @Override
    protected List<ClassRefSignatureModel> prepareInterfaces() {
        return this.origin.getTypeSignatureOrTypeDescriptor().getSuperinterfaceSignatures().stream().map(ClassRefSignatureModel::of).collect(Collectors.toList());
    }

    @Override
    protected List<MethodInfoModel> prepareMethods() {
        return this.origin.getDeclaredMethodInfo().stream().map(MethodInfoModel::of).sorted(MethodInfoModel.METHOD_ORDER).collect(Collectors.toList());
    }

    @Override
    protected List<PackageInfoModel> prepareAncestors() {
        return List.of(PackageInfoModel.of(this.origin.getPackageInfo()));
    }

    @Override
    protected ClassRefSignatureModel prepareSuperClass() {
        ClassRefTypeSignature superClass = this.origin.getTypeSignatureOrTypeDescriptor().getSuperclassSignature();
        return superClass != null ? ClassRefSignatureModel.of(superClass) : null;
    }

    @Override
    protected List<TypeParameterModel> prepareTypeParameters() {
        return this.origin.getTypeSignatureOrTypeDescriptor().getTypeParameters().stream().map(TypeParameterModel::of).collect(Collectors.toList());
    }
}

