/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.RootNode;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class NodePath<N extends Node<?, ?>> {
    private final N node;
    private final NodePath<?> parentPath;
    private final NodePath<RootNode> rootPath;

    private NodePath(@Nonnull N node, @Nonnull NodePath<?> parentPath) {
        this.node = (Node)Objects.requireNonNull(node);
        this.parentPath = Objects.requireNonNull(parentPath);
        this.rootPath = Objects.requireNonNull(parentPath.getRootPath());
    }

    private NodePath(@Nonnull N node) {
        if (!(node instanceof RootNode)) {
            throw new IllegalArgumentException("RootNode instance required");
        }
        this.node = (Node)Objects.requireNonNull(node);
        this.parentPath = this;
        this.rootPath = this;
    }

    static NodePath<RootNode> forRoot(@Nonnull RootNode rootNode) {
        return new NodePath<RootNode>(rootNode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePath<?> otherPath = (NodePath<?>)o;
        NodePath<?> thisPath = this;
        while (thisPath.getNode().equals(otherPath.getNode())) {
            if (thisPath.hasParentNodes() || otherPath.hasParentNodes()) {
                thisPath = thisPath.getParentPath();
                otherPath = otherPath.getParentPath();
                continue;
            }
            return true;
        }
        return false;
    }

    public Node<?, ?> getNode() {
        return this.node;
    }

    public NodePath<?> getParentPath() {
        return this.parentPath;
    }

    public NodePath<RootNode> getRootPath() {
        return this.rootPath;
    }

    public boolean hasParentNodes() {
        return this.getNode() != this.getParentPath().getNode();
    }

    public int hashCode() {
        int hash = 0xA73FC160 ^ this.node.hashCode();
        NodePath<?> thisPath = this;
        while (thisPath.hasParentNodes()) {
            thisPath = thisPath.getParentPath();
            hash ^= thisPath.getNode().hashCode();
        }
        return hash;
    }

    public Stream<NodePath<?>> stream() {
        return Stream.iterate(this, NodePath::hasParentNodes, NodePath::getParentPath);
    }

    public String toString() {
        LinkedList<String> list = new LinkedList<String>();
        NodePath<?> path = this;
        list.add(path.getNode().toString());
        while (path.hasParentNodes()) {
            path = path.getParentPath();
            list.addFirst("/");
            list.addFirst(path.getNode().toString());
        }
        return String.join((CharSequence)"", list);
    }

    <N extends Node<?, ?>> NodePath<N> withChildNode(@Nonnull N node) {
        return new NodePath<N>(node, this);
    }
}

