/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import dev.hilla.parser.core.Node;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.NamedModel;
import dev.hilla.parser.models.SignatureModel;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class AbstractNode<S, T>
implements Node<S, T> {
    private final S source;
    private T target;

    protected AbstractNode(@Nonnull S source, T target) {
        this.source = Objects.requireNonNull(source);
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNode node = (AbstractNode)o;
        return this.source.equals(node.getSource());
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(T target) {
        this.target = target;
    }

    public int hashCode() {
        return this.source.hashCode() ^ 0x42EBEB0;
    }

    public String toString() {
        String sourceName = "";
        sourceName = this.source instanceof ClassInfoModel ? ((ClassInfoModel)this.source).getSimpleName() : (this.source instanceof SignatureModel ? this.source.toString() : (this.source instanceof NamedModel ? ((NamedModel)this.source).getName() : this.source.getClass().getSimpleName()));
        return this.getClass().getSimpleName().replaceAll("Node$", "") + "(" + sourceName + ")";
    }
}

