/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.engine.commandrunner;

import com.vaadin.flow.server.frontend.FrontendUtils;
import dev.hilla.engine.commandrunner.CommandNotFoundException;
import dev.hilla.engine.commandrunner.CommandRunnerException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

public interface CommandRunner {
    public static final boolean IS_WINDOWS = FrontendUtils.isWindows();

    public String[] testArguments();

    public String[] arguments();

    public Logger getLogger();

    public File currentDirectory();

    public List<String> executables();

    default public void run(Consumer<OutputStream> stdIn) throws CommandRunnerException {
        String executable = this.executables().stream().filter(this::executeWithTestArguments).findFirst().orElseThrow(() -> new CommandNotFoundException("No valid executable found"));
        this.getLogger().debug("Running command {}", (Object)executable);
        this.executeCommand(executable, this.arguments(), stdIn, true);
    }

    private boolean executeWithTestArguments(String command) {
        try {
            String[] args = this.testArguments();
            this.getLogger().debug("Testing command {} with arguments {}", (Object)command, (Object)args);
            this.executeCommand(command, args, null, false);
            return true;
        }
        catch (CommandRunnerException e) {
            this.getLogger().debug("Testing command {} failed", (Object)command, (Object)e);
            return false;
        }
    }

    private void executeCommand(String executable, String[] arguments, Consumer<OutputStream> stdIn, boolean stdOut) throws CommandRunnerException {
        List<String> commandWithArgs;
        Stream<String> cmdStream = Stream.concat(Stream.of(executable), Arrays.stream(arguments));
        List<String> list = commandWithArgs = IS_WINDOWS ? List.of("cmd.exe", "/c", cmdStream.map(arg -> arg.contains(" ") ? "\"" + arg + "\"" : arg).collect(Collectors.joining(" ", "\"", "\""))) : cmdStream.collect(Collectors.toList());
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Running command: \"{}\" in directory \"{}\"", (Object)String.join((CharSequence)" ", commandWithArgs), (Object)this.currentDirectory());
        }
        int exitCode = 0;
        try {
            ProcessBuilder processBuilder = this.createProcessBuilder(commandWithArgs, stdOut);
            Process process = processBuilder.start();
            if (stdIn != null) {
                try (OutputStream outputStream = process.getOutputStream();){
                    stdIn.accept(outputStream);
                }
            }
            exitCode = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains("No such file or directory")) {
                throw new CommandNotFoundException("Command or file not found: " + executable, e);
            }
            throw new CommandRunnerException("Failed to execute command: " + executable, e);
        }
        if (exitCode != 0) {
            throw new CommandRunnerException("Command failed with exit code " + exitCode + ": " + executable);
        }
    }

    default public ProcessBuilder createProcessBuilder(List<String> commandWithArgs, boolean stdOut) {
        ProcessBuilder builder = new ProcessBuilder(commandWithArgs).directory(this.currentDirectory());
        builder.environment().putAll(this.environment());
        if (stdOut) {
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        return builder;
    }

    default public ProcessHandle.Info getCurrentProcessInfo() {
        return ProcessHandle.current().info();
    }

    private String getCurrentJavaProcessJavaHome() {
        return this.getCurrentProcessInfo().command().map(javaExecPath -> {
            String pathToExclude = IS_WINDOWS ? "\\bin\\java.exe" : "/bin/java";
            return javaExecPath.substring(0, javaExecPath.lastIndexOf(pathToExclude));
        }).orElse(System.getProperty("java.home"));
    }

    default public Map<String, String> environment() {
        return Map.of("JAVA_HOME", this.getCurrentJavaProcessJavaHome());
    }
}

