/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import dev.hilla.Endpoint;
import java.util.HashSet;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

class EndpointInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    EndpointInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        String[] endpoints = beanFactory.getBeanNamesForAnnotation(Endpoint.class);
        final HashSet<Class> endpointClasses = new HashSet<Class>();
        for (String endpoint : endpoints) {
            endpointClasses.add(beanFactory.getType(endpoint));
        }
        return new BeanFactoryInitializationAotContribution(){

            public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
                for (Class endpointClass : endpointClasses) {
                    generationContext.getRuntimeHints().reflection().registerType(endpointClass, MemberCategory.values());
                }
            }
        };
    }
}

