/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class UnevaluatedPropertiesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    UnevaluatedPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Set<String> evaluatedInstances = ctx.calculateEvaluatedProperties(node.getJsonPointer());
        HashSet<String> processed = new HashSet<String>();
        boolean valid = true;
        for (Map.Entry<String, JsonNode> entry : node.asObject().entrySet()) {
            if (evaluatedInstances.contains(entry.getKey())) continue;
            processed.add(entry.getKey());
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, entry.getValue()) && valid;
        }
        return valid ? Evaluator.Result.success(processed) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 20;
    }
}

