/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UnevaluatedItemsEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    UnevaluatedItemsEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        Map.Entry<Integer, Set<Integer>> evaluated = ctx.calculateEvaluatedItems(node.getJsonPointer());
        List<JsonNode> array = node.asArray();
        if (evaluated.getKey() >= array.size()) {
            return Evaluator.Result.success();
        }
        Set<Integer> evaluatedIndices = evaluated.getValue();
        boolean valid = true;
        for (int i = evaluated.getKey().intValue(); i < array.size(); ++i) {
            if (evaluatedIndices.contains(i)) continue;
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, array.get(i)) && valid;
        }
        return valid ? Evaluator.Result.success(true) : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 30;
    }
}

