/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import dev.harrel.jsonschema.StringNode;

class PropertyNamesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    PropertyNamesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        boolean valid = true;
        for (String propName : node.asObject().keySet()) {
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)new StringNode(propName, node.getJsonPointer())) && valid;
        }
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure();
    }
}

