/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.regex.Pattern;

class PatternEvaluator
implements Evaluator {
    private final Pattern pattern;

    PatternEvaluator(JsonNode node) {
        if (!node.isString()) {
            throw new IllegalArgumentException();
        }
        this.pattern = Pattern.compile(node.asString());
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isString()) {
            return Evaluator.Result.success();
        }
        if (this.pattern.matcher(node.asString()).find()) {
            return Evaluator.Result.success();
        }
        return Evaluator.Result.failure(() -> String.format("\"%s\" does not match regular expression [%s]", node.asString(), this.pattern));
    }
}

