/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Dialect;
import dev.harrel.jsonschema.Draft2019EvaluatorFactory;
import dev.harrel.jsonschema.Draft2020EvaluatorFactory;
import dev.harrel.jsonschema.Draft4EvaluatorFactory;
import dev.harrel.jsonschema.Draft6EvaluatorFactory;
import dev.harrel.jsonschema.Draft7EvaluatorFactory;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.SpecificationVersion;
import dev.harrel.jsonschema.UriUtil;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Dialects {
    static final Map<URI, Dialect> OFFICIAL_DIALECTS;

    private Dialects() {
    }

    static {
        HashMap<URI, BaseDialect> map = new HashMap<URI, BaseDialect>();
        map.put(URI.create(SpecificationVersion.DRAFT2020_12.getId()), new Draft2020Dialect());
        map.put(URI.create(SpecificationVersion.DRAFT2019_09.getId()), new Draft2019Dialect());
        map.put(UriUtil.removeEmptyFragment(SpecificationVersion.DRAFT7.getId()), new Draft7Dialect());
        map.put(UriUtil.removeEmptyFragment(SpecificationVersion.DRAFT6.getId()), new Draft6Dialect());
        map.put(UriUtil.removeEmptyFragment(SpecificationVersion.DRAFT4.getId()), new Draft4Dialect());
        OFFICIAL_DIALECTS = Collections.unmodifiableMap(map);
    }

    public static class Draft2020Dialect
    extends BaseDialect {
        public Draft2020Dialect() {
            super(SpecificationVersion.DRAFT2020_12, new Draft2020EvaluatorFactory(), Collections.singleton("https://json-schema.org/draft/2020-12/vocab/core"), Draft2020Dialect.createDefaultVocabularyObject());
        }

        private static Map<String, Boolean> createDefaultVocabularyObject() {
            HashMap<String, Boolean> vocabs = new HashMap<String, Boolean>();
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/core", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/applicator", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/unevaluated", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/validation", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/meta-data", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/format-annotation", true);
            vocabs.put("https://json-schema.org/draft/2020-12/vocab/content", true);
            return Collections.unmodifiableMap(vocabs);
        }
    }

    public static class Draft2019Dialect
    extends BaseDialect {
        public Draft2019Dialect() {
            super(SpecificationVersion.DRAFT2019_09, new Draft2019EvaluatorFactory(), Collections.singleton("https://json-schema.org/draft/2019-09/vocab/core"), Draft2019Dialect.createDefaultVocabularyObject());
        }

        private static Map<String, Boolean> createDefaultVocabularyObject() {
            HashMap<String, Boolean> vocabs = new HashMap<String, Boolean>();
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/core", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/applicator", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/validation", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/meta-data", true);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/format", false);
            vocabs.put("https://json-schema.org/draft/2019-09/vocab/content", true);
            return Collections.unmodifiableMap(vocabs);
        }
    }

    public static class Draft7Dialect
    extends BaseDialect {
        public Draft7Dialect() {
            super(SpecificationVersion.DRAFT7, new Draft7EvaluatorFactory(), Collections.emptySet(), Collections.emptyMap());
        }
    }

    public static class Draft6Dialect
    extends BaseDialect {
        public Draft6Dialect() {
            super(SpecificationVersion.DRAFT6, new Draft6EvaluatorFactory(), Collections.emptySet(), Collections.emptyMap());
        }
    }

    public static class Draft4Dialect
    extends BaseDialect {
        public Draft4Dialect() {
            super(SpecificationVersion.DRAFT4, new Draft4EvaluatorFactory(), Collections.emptySet(), Collections.emptyMap());
        }
    }

    private static class BaseDialect
    implements Dialect {
        private final SpecificationVersion specificationVersion;
        private final EvaluatorFactory evaluatorFactory;
        private final Set<String> requiredVocabularies;
        private final Map<String, Boolean> defaultVocabularyObject;

        private BaseDialect(SpecificationVersion specificationVersion, EvaluatorFactory evaluatorFactory, Set<String> requiredVocabularies, Map<String, Boolean> defaultVocabularyObject) {
            this.specificationVersion = specificationVersion;
            this.evaluatorFactory = evaluatorFactory;
            this.requiredVocabularies = requiredVocabularies;
            this.defaultVocabularyObject = defaultVocabularyObject;
        }

        @Override
        public SpecificationVersion getSpecificationVersion() {
            return this.specificationVersion;
        }

        @Override
        public String getMetaSchema() {
            return this.specificationVersion.getId();
        }

        @Override
        public EvaluatorFactory getEvaluatorFactory() {
            return this.evaluatorFactory;
        }

        @Override
        public Set<String> getSupportedVocabularies() {
            return this.defaultVocabularyObject.keySet();
        }

        @Override
        public Set<String> getRequiredVocabularies() {
            return this.requiredVocabularies;
        }

        @Override
        public Map<String, Boolean> getDefaultVocabularyObject() {
            return this.defaultVocabularyObject;
        }
    }
}

