/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.SimpleType;
import dev.harrel.jsonschema.providers.AbstractJsonNode;
import dev.harrel.jsonschema.providers.MapUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class GsonNode
extends AbstractJsonNode<JsonElement> {
    private BigDecimal asNumber;

    private GsonNode(JsonElement node, String jsonPointer) {
        super(Objects.requireNonNull(node), jsonPointer);
    }

    public GsonNode(JsonElement node) {
        this(node, "");
    }

    @Override
    public boolean asBoolean() {
        return ((JsonElement)this.node).getAsBoolean();
    }

    @Override
    public String asString() {
        return ((JsonElement)this.node).getAsString();
    }

    @Override
    public BigInteger asInteger() {
        return this.asNumber.toBigInteger();
    }

    @Override
    public BigDecimal asNumber() {
        return this.asNumber;
    }

    @Override
    List<JsonNode> createArray() {
        List elements = ((JsonElement)this.node).getAsJsonArray().asList();
        ArrayList<JsonNode> result = new ArrayList<JsonNode>(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            result.add(new GsonNode((JsonElement)elements.get(i), this.jsonPointer + "/" + i));
        }
        return result;
    }

    @Override
    Map<String, JsonNode> createObject() {
        Set objectMap = ((JsonElement)this.node).getAsJsonObject().entrySet();
        HashMap<String, JsonNode> result = MapUtil.newHashMap(objectMap.size());
        for (Map.Entry entry : objectMap) {
            result.put((String)entry.getKey(), new GsonNode((JsonElement)entry.getValue(), this.jsonPointer + "/" + JsonNode.encodeJsonPointer((String)entry.getKey())));
        }
        return result;
    }

    @Override
    public String toPrintableString() {
        if (this.isNull()) {
            return "null";
        }
        return super.toPrintableString();
    }

    @Override
    SimpleType computeNodeType(JsonElement node) {
        if (node.isJsonNull()) {
            return SimpleType.NULL;
        }
        if (node.isJsonArray()) {
            return SimpleType.ARRAY;
        }
        if (node.isJsonObject()) {
            return SimpleType.OBJECT;
        }
        JsonPrimitive jsonPrimitive = node.getAsJsonPrimitive();
        if (jsonPrimitive.isBoolean()) {
            return SimpleType.BOOLEAN;
        }
        if (jsonPrimitive.isString()) {
            return SimpleType.STRING;
        }
        this.asNumber = jsonPrimitive.getAsBigDecimal();
        if (GsonNode.canConvertToInteger(this.asNumber)) {
            return SimpleType.INTEGER;
        }
        return SimpleType.NUMBER;
    }

    public static final class Factory
    implements JsonNodeFactory {
        @Override
        public GsonNode wrap(Object node) {
            if (node instanceof GsonNode) {
                return new GsonNode((JsonElement)((GsonNode)node).node);
            }
            if (node instanceof JsonElement) {
                return new GsonNode((JsonElement)node);
            }
            throw new IllegalArgumentException("Cannot wrap object which is not an instance of com.google.gson.JsonElement");
        }

        @Override
        public GsonNode create(String rawJson) {
            return new GsonNode(JsonParser.parseString((String)rawJson));
        }
    }
}

