/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ItemsLegacyEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;
    private final List<CompoundUri> schemaRefs;

    ItemsLegacyEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (node.isObject() || node.isBoolean()) {
            this.schemaRef = ctx.getCompoundUri(node);
            this.schemaRefs = null;
        } else if (node.isArray()) {
            this.schemaRef = null;
            this.schemaRefs = Collections.unmodifiableList(node.asArray().stream().map(ctx::getCompoundUri).collect(Collectors.toList()));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray()) {
            return Evaluator.Result.success();
        }
        List<JsonNode> array = node.asArray();
        if (this.schemaRef != null) {
            boolean valid = array.stream().filter(element -> ctx.resolveInternalRefAndValidate(this.schemaRef, (JsonNode)element)).count() == (long)array.size();
            return valid ? Evaluator.Result.success(true) : Evaluator.Result.failure();
        }
        int size = Math.min(this.schemaRefs.size(), array.size());
        boolean valid = IntStream.range(0, size).boxed().filter(idx -> ctx.resolveInternalRefAndValidate(this.schemaRefs.get((int)idx), (JsonNode)array.get((int)idx))).count() == (long)size;
        return valid ? Evaluator.Result.success(this.schemaRefs.size()) : Evaluator.Result.failure();
    }
}

