/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema.providers;

import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SimpleType;
import java.util.List;
import java.util.Map;
import java.util.Objects;

abstract class AbstractJsonNode<T>
implements JsonNode {
    private final SimpleType nodeType;
    final T node;
    final String jsonPointer;
    private Map<String, JsonNode> asObject;
    private List<JsonNode> asArray;

    AbstractJsonNode(T node, String jsonPointer) {
        this.nodeType = this.computeNodeType(node);
        this.node = node;
        this.jsonPointer = Objects.requireNonNull(jsonPointer);
    }

    @Override
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Override
    public SimpleType getNodeType() {
        return this.nodeType;
    }

    @Override
    public final List<JsonNode> asArray() {
        if (this.asArray != null) {
            return this.asArray;
        }
        this.asArray = this.createArray();
        return this.asArray;
    }

    @Override
    public final Map<String, JsonNode> asObject() {
        if (this.asObject != null) {
            return this.asObject;
        }
        this.asObject = this.createObject();
        return this.asObject;
    }

    abstract List<JsonNode> createArray();

    abstract Map<String, JsonNode> createObject();

    abstract SimpleType computeNodeType(T var1);
}

