/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import java.util.stream.Collectors;

public enum SpecificationVersion {
    DRAFT2020_12("https://json-schema.org/draft/2020-12", "/draft2020-12.json"){

        @Override
        Optional<String> resolveResource(String uri) {
            return this.getId().equals(uri) ? SpecificationVersion.readFileResource(this.getResourcePath()) : Optional.empty();
        }
    }
    ,
    DRAFT2019_09("https://json-schema.org/draft/2019-09", "/dev/harrel/jsonschema/draft/2019-09/schema.json");

    private final URI baseUri;
    private final String id;
    private final String resourcePath;
    private final URI resourcePathUri;

    private SpecificationVersion(String baseUri, String resourcePath) {
        this.baseUri = URI.create(baseUri);
        this.id = baseUri + "/schema";
        this.resourcePath = resourcePath;
        this.resourcePathUri = URI.create(resourcePath);
    }

    Optional<String> resolveResource(String uri) {
        if (!uri.startsWith(this.getBaseUri().toString())) {
            return Optional.empty();
        }
        String relativeUri = uri.substring(this.getBaseUri().toString().length() + 1);
        URI resolvedUri = this.getResourcePathUri().resolve(relativeUri);
        return SpecificationVersion.readFileResource(resolvedUri + ".json");
    }

    public String getId() {
        return this.id;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    URI getBaseUri() {
        return this.baseUri;
    }

    URI getResourcePathUri() {
        return this.resourcePathUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> readFileResource(String uri) {
        try (InputStream is = SpecificationVersion.class.getResourceAsStream(uri);){
            if (is == null) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Optional<String> optional = Optional.of(new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining()));
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

