/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Objects;
import java.util.Set;

final class EvaluatorWrapper
implements Evaluator {
    private final String keyword;
    private final String keywordPath;
    private final Evaluator evaluator;

    EvaluatorWrapper(String keyword, String keywordPath, Evaluator evaluator) {
        this.keyword = keyword;
        this.keywordPath = Objects.requireNonNull(keywordPath);
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    EvaluatorWrapper(String keyword, JsonNode keywordNode, Evaluator evaluator) {
        this(keyword, keywordNode.getJsonPointer(), evaluator);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode instanceNode) {
        return this.evaluator.evaluate(ctx, instanceNode);
    }

    @Override
    public int getOrder() {
        return this.evaluator.getOrder();
    }

    @Override
    public Set<String> getVocabularies() {
        return this.evaluator.getVocabularies();
    }

    String getKeyword() {
        return this.keyword;
    }

    String getKeywordPath() {
        return this.keywordPath;
    }
}

