/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Stream;
import dev.fileformat.drako.StreamReader;
import dev.fileformat.drako.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@Internal
class XmlReader {
    private XMLStreamReader _reader;
    private int nextDepth = 0;
    private boolean eof = false;
    private XmlEvent event;

    public XmlReader(Reader reader) {
        try {
            this._reader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
            this.event = new XmlEvent();
            this.event.next = this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public XmlReader(String str) {
        this(new StringReader(str));
    }

    public XmlReader(Stream stream) throws IOException {
        this(new StreamReader(stream));
    }

    public boolean isEmptyElement() {
        return this.event == null ? false : this.event.emptyElement;
    }

    public int getDepth() {
        return this.event == null ? 0 : this.event.depth;
    }

    private XmlEvent nextEvent() throws XMLStreamException {
        if (!this._reader.hasNext()) {
            return null;
        }
        int event = this._reader.next();
        return this.nextEvent(event);
    }

    private XmlEvent nextEvent(int event) throws XMLStreamException {
        XmlEvent e = new XmlEvent();
        e.depth = this.nextDepth;
        e.type = event;
        switch (event) {
            case 1: {
                e.localName = this._reader.getLocalName();
                e.namespaceURI = this._reader.getNamespaceURI();
                e.attributes = new HashMap<String, String>();
                int numAttrs = this._reader.getAttributeCount();
                for (int i = 0; i < numAttrs; ++i) {
                    QName key = this._reader.getAttributeName(i);
                    String value = this._reader.getAttributeValue(i);
                    String attribute = key.getLocalPart();
                    if (key.getPrefix() != null && key.getPrefix().length() > 0) {
                        attribute = StringUtils.concat(key.getPrefix(), ":", key.getLocalPart());
                    }
                    e.attributes.put(attribute, value);
                }
                int next = this._reader.next();
                if (next != 2) {
                    this.nextDepth = e.depth + 1;
                    e.next = this.nextEvent(next);
                    break;
                }
                this.nextDepth = e.depth;
                e.emptyElement = true;
                break;
            }
            case 2: {
                e.localName = this._reader.getLocalName();
                e.namespaceURI = this._reader.getNamespaceURI();
                e.depth = this.nextDepth = e.depth - 1;
                break;
            }
            case 8: {
                this.eof = true;
                return null;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                int next;
                StringBuilder sb = new StringBuilder();
                sb.append(this._reader.getText());
                while (true) {
                    if ((next = this._reader.next()) != e.type) break;
                    sb.append(this._reader.getText());
                }
                e.next = this.nextEvent(next);
                e.value = sb.toString();
                break;
            }
        }
        return e;
    }

    public boolean read() throws XMLStreamException {
        if (this.event == null) {
            return false;
        }
        if (this.event.next != null) {
            this.event = this.event.next;
            return true;
        }
        this.event = this.nextEvent();
        return this.event != null;
    }

    public int getNodeType() {
        return this.event == null ? 0 : this.event.type;
    }

    public void skip() throws XMLStreamException {
        int nodeType = this.getNodeType();
        if (nodeType == 1 && !this.isEmptyElement()) {
            int d = this.getDepth();
            String nodeName = this.getLocalName();
            while (this.read() && (this.getDepth() != d || this.getNodeType() != 2 || !nodeName.equals(this.getLocalName()))) {
            }
        }
        this.read();
    }

    public void readEndElement() throws XMLStreamException {
        if (this.getNodeType() != 2) {
            throw new XMLStreamException("Invalid node type, must be end element");
        }
        this.read();
    }

    public boolean isEOF() {
        return this.eof;
    }

    public String readContentAsString() throws XMLStreamException {
        int nodeType = this.getNodeType();
        switch (nodeType) {
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                throw new XMLStreamException("Invalid content to read.");
            }
        }
        String ret = this.getValue();
        this.read();
        return ret;
    }

    public String getNamespaceURI() {
        return this.event == null ? "" : this.event.namespaceURI;
    }

    public String getLocalName() {
        return this.event == null ? "" : this.event.localName;
    }

    public String getValue() {
        return this.event == null ? "" : this.event.value;
    }

    public String getAttribute(String key) {
        return this.event.attributes.get(key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.getNodeType()) {
            case 2: {
                sb.append("EndElement");
                break;
            }
            case 1: {
                sb.append("Element");
                break;
            }
            case 4: {
                sb.append("Text");
                break;
            }
            case 12: {
                sb.append("CDATA");
                break;
            }
            case 6: {
                sb.append("Whitespace");
                break;
            }
            default: {
                sb.append("????");
            }
        }
        sb.append(" ");
        sb.append(this.getLocalName());
        sb.append(" ");
        sb.append(Integer.toString(this.getDepth()));
        return sb.toString();
    }

    static class XmlEvent {
        int type;
        String value = "";
        String localName = "";
        String namespaceURI = "";
        boolean emptyElement;
        Map<String, String> attributes = Collections.emptyMap();
        int depth;
        XmlEvent next;

        XmlEvent() {
        }
    }
}

