/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;

@Internal
class Span {
    protected final int offset;
    protected final int length;

    protected Span(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    protected final void rangeCheck(int idx) {
        if (idx > this.length || idx < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public final int offset() {
        return this.offset;
    }

    public final int size() {
        return this.length;
    }

    protected static int getIntL(byte[] array, int offset) {
        return array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 3] & 0xFF) << 24;
    }

    protected static long getLongL(byte[] array, int offset) {
        return (long)array[offset] & 0xFFL | (long)((array[offset + 1] & 0xFF) << 8) | ((long)((array[offset + 2] & 0xFF) << 16) | (long)(array[offset + 3] & 0xFF) << 24) | (long)(array[offset + 4] & 0xFF) << 32 | (long)(array[offset + 5] & 0xFF) << 40 | (long)(array[offset + 6] & 0xFF) << 48 | (long)(array[offset + 7] & 0xFF) << 56;
    }

    protected static void putIntL(byte[] array, int offset, int value) {
        array[offset] = (byte)value;
        array[offset + 1] = (byte)(value >> 8);
        array[offset + 2] = (byte)(value >> 16);
        array[offset + 3] = (byte)(value >>> 24);
    }

    protected static void putLongL(byte[] array, int offset, long value) {
        array[offset] = (byte)value;
        array[offset + 1] = (byte)(value >> 8);
        array[offset + 2] = (byte)(value >> 16);
        array[offset + 3] = (byte)(value >>> 24);
        array[offset + 4] = (byte)(value >>> 32);
        array[offset + 5] = (byte)(value >>> 40);
        array[offset + 6] = (byte)(value >>> 48);
        array[offset + 7] = (byte)(value >>> 56);
    }
}

