/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeOctahedronTransform;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.PredictionScheme;
import dev.fileformat.drako.PredictionSchemeNormalOctahedronCanonicalizedTransform;
import dev.fileformat.drako.PredictionSchemeTransform;
import dev.fileformat.drako.SequentialAttributeEncoder;
import dev.fileformat.drako.SequentialIntegerAttributeEncoder;
import dev.fileformat.drako.Vector3;

class SequentialNormalAttributeEncoder
extends SequentialIntegerAttributeEncoder {
    private AttributeOctahedronTransform attribute_octahedron_transform_;

    SequentialNormalAttributeEncoder() {
    }

    @Override
    public int getUniqueId() {
        return 3;
    }

    @Override
    public boolean isLossyEncoder() {
        return true;
    }

    @Override
    public void initialize(PointCloudEncoder encoder, int attributeId) throws DrakoException {
        super.initialize(encoder, attributeId);
        if (this.getAttribute().getComponentsCount() != 3) {
            throw DracoUtils.failed();
        }
        int q = encoder.getOptions().getQuantizationBits(this.attribute);
        if (q < 1) {
            throw DracoUtils.failed();
        }
        this.attribute_octahedron_transform_ = new AttributeOctahedronTransform(q);
    }

    @Override
    public void encodeDataNeededByPortableTransform(EncoderBuffer out_buffer) throws DrakoException {
        this.attribute_octahedron_transform_.encodeParameters(out_buffer);
    }

    @Override
    protected void prepareValues(int[] pointIds, int numPoints) {
        this.portableAttribute = this.attribute_octahedron_transform_.generatePortableAttribute(this.getAttribute(), pointIds, numPoints);
    }

    static void unitVectorToOctahedralCoords(Vector3 vector, float[] outS, float[] outT) {
        float absSum = Math.abs(vector.x) + Math.abs(vector.y) + Math.abs(vector.z);
        Vector3 scaledVec = new Vector3();
        if ((double)absSum > 1.0E-6) {
            float scale = 1.0f / absSum;
            scaledVec.x = vector.x * scale;
            scaledVec.y = vector.y * scale;
            scaledVec.z = vector.z * scale;
        } else {
            scaledVec.x = 1.0f;
            scaledVec.y = 0.0f;
            scaledVec.z = 0.0f;
        }
        if (scaledVec.x >= 0.0f) {
            outS[0] = (scaledVec.y + 1.0f) * 0.5f;
            outT[0] = (scaledVec.z + 1.0f) * 0.5f;
        } else {
            outS[0] = scaledVec.y < 0.0f ? 0.5f * Math.abs(scaledVec.z) : 0.5f * (2.0f - Math.abs(scaledVec.z));
            outT[0] = scaledVec.z < 0.0f ? 0.5f * Math.abs(scaledVec.y) : 0.5f * (2.0f - Math.abs(scaledVec.y));
        }
    }

    static void unitVectorToQuantizedOctahedralCoords(Vector3 vector, float maxQuantizedValue, int[] outS, int[] outT) {
        float maxValue = maxQuantizedValue - 1.0f;
        float[] ref0 = new float[1];
        float[] ref1 = new float[1];
        SequentialNormalAttributeEncoder.unitVectorToOctahedralCoords(vector, ref0, ref1);
        float ss = ref0[0];
        float tt = ref1[0];
        int s = (int)Math.floor((double)(ss * maxValue) + 0.5);
        int t = (int)Math.floor((double)(tt * maxValue) + 0.5);
        int centerValue = (int)(maxValue / 2.0f);
        if (s == 0 && t == 0 || s == 0 && (float)t == maxValue || (float)s == maxValue && t == 0) {
            s = (int)maxValue;
            t = (int)maxValue;
        } else if (s == 0 && t > centerValue) {
            t = centerValue - (t - centerValue);
        } else if ((float)s == maxValue && t < centerValue) {
            t = centerValue + (centerValue - t);
        } else if ((float)t == maxValue && s < centerValue) {
            s = centerValue + (centerValue - s);
        } else if (t == 0 && s > centerValue) {
            s = centerValue - (s - centerValue);
        }
        outS[0] = s;
        outT[0] = t;
    }

    @Override
    protected PredictionScheme createIntPredictionScheme(int method) {
        int quantizationBits = this.getEncoder().getOptions().getQuantizationBits(this.getAttribute());
        int maxValue = (1 << quantizationBits) - 1;
        PredictionSchemeNormalOctahedronCanonicalizedTransform transform = new PredictionSchemeNormalOctahedronCanonicalizedTransform(maxValue);
        int prediction_method = SequentialAttributeEncoder.selectPredictionMethod(this.getAttributeId(), this.getEncoder());
        if (prediction_method == 6 || prediction_method == 0) {
            return PredictionScheme.create(this.getEncoder(), prediction_method, this.getAttributeId(), (PredictionSchemeTransform)transform);
        }
        return null;
    }
}

