/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributesDecoder;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointsSequencer;
import dev.fileformat.drako.SequentialAttributeDecoder;
import dev.fileformat.drako.SequentialIntegerAttributeDecoder;
import dev.fileformat.drako.SequentialNormalAttributeDecoder;
import dev.fileformat.drako.SequentialQuantizationAttributeDecoder;

class SequentialAttributeDecodersController
extends AttributesDecoder {
    private SequentialAttributeDecoder[] sequentialDecoders;
    private int[] pointIds;
    private PointsSequencer sequencer;

    public SequentialAttributeDecodersController(PointsSequencer sequencer) {
        this.sequencer = sequencer;
    }

    @Override
    public void decodeAttributesDecoderData(DecoderBuffer buffer) throws DrakoException {
        super.decodeAttributesDecoderData(buffer);
        this.sequentialDecoders = new SequentialAttributeDecoder[this.getNumAttributes()];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            byte decoderType = buffer.decodeU8();
            this.sequentialDecoders[i] = this.createSequentialDecoder(0xFF & decoderType);
            if (this.sequentialDecoders[i] == null) {
                throw DracoUtils.failed();
            }
            this.sequentialDecoders[i].initialize(this.getDecoder(), this.getAttributeId(i));
        }
    }

    @Override
    public void decodeAttributes(DecoderBuffer buffer) throws DrakoException {
        if (this.sequencer == null) {
            throw DracoUtils.failed();
        }
        this.pointIds = this.sequencer.generateSequence();
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            PointAttribute pa = this.getDecoder().getPointCloud().attribute(this.getAttributeId(i));
            this.sequencer.updatePointToAttributeIndexMapping(pa);
        }
        super.decodeAttributes(buffer);
    }

    @Override
    protected void decodePortableAttributes(DecoderBuffer buffer) throws DrakoException {
        int num_attributes = this.getNumAttributes();
        for (int i = 0; i < num_attributes; ++i) {
            this.sequentialDecoders[i].decodePortableAttribute(this.pointIds, buffer);
        }
    }

    @Override
    protected void decodeDataNeededByPortableTransforms(DecoderBuffer buffer) throws DrakoException {
        int num_attributes = this.getNumAttributes();
        for (int i = 0; i < num_attributes; ++i) {
            this.sequentialDecoders[i].decodeDataNeededByPortableTransform(this.pointIds, buffer);
        }
    }

    @Override
    protected void transformAttributesToOriginalFormat() throws DrakoException {
        int num_attributes = this.getNumAttributes();
        for (int i = 0; i < num_attributes; ++i) {
            if (this.getDecoder().options != null) {
                PointAttribute attribute = this.sequentialDecoders[i].getAttribute();
                if (this.getDecoder().options.skipAttributeTransform) {
                    this.sequentialDecoders[i].getAttribute().copyFrom(this.sequentialDecoders[i].getPortableAttribute());
                    continue;
                }
            }
            this.sequentialDecoders[i].transformAttributeToOriginalFormat(this.pointIds);
        }
    }

    protected SequentialAttributeDecoder createSequentialDecoder(int decoderType) {
        switch (decoderType) {
            case 0: {
                return new SequentialAttributeDecoder();
            }
            case 1: {
                return new SequentialIntegerAttributeDecoder();
            }
            case 2: {
                return new SequentialQuantizationAttributeDecoder();
            }
            case 3: {
                return new SequentialNormalAttributeDecoder();
            }
        }
        return null;
    }

    @Override
    public PointAttribute getPortableAttribute(int attId) {
        int loc_id = this.getLocalIdForPointAttribute(attId);
        if (loc_id < 0) {
            return null;
        }
        return this.sequentialDecoders[loc_id].getPortableAttribute();
    }
}

