/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.IntSpan;

class PredictionSchemeTransform {
    protected int numComponents;

    PredictionSchemeTransform() {
    }

    public int getType() {
        return 0;
    }

    public void initializeEncoding(IntSpan origData, int numComponents) {
        this.numComponents = numComponents;
    }

    public void initializeDecoding(int numComponents) {
        this.numComponents = numComponents;
    }

    public void computeCorrection(IntSpan originalVals, int originalOffset, IntSpan predictedVals, int predictedOffset, IntSpan outCorrVals, int outOffset, int valId) {
        outOffset += valId;
        for (int i = 0; i < this.numComponents; ++i) {
            outCorrVals.put(outOffset + i, originalVals.get(originalOffset + i) - predictedVals.get(predictedOffset + i));
        }
    }

    public void computeCorrection(IntSpan originalVals, IntSpan predictedVals, IntSpan outCorrVals, int valId) {
        this.computeCorrection(originalVals, 0, predictedVals, 0, outCorrVals, 0, valId);
    }

    public void computeOriginalValue(IntSpan predictedVals, int predictedOffset, IntSpan corrVals, int corrOffset, IntSpan outOriginalVals, int outOffset) {
        for (int i = 0; i < this.numComponents; ++i) {
            outOriginalVals.put(i + outOffset, predictedVals.get(i + predictedOffset) + corrVals.get(i + corrOffset));
        }
    }

    public void computeOriginalValue(IntSpan predictedVals, IntSpan corrVals, IntSpan outOriginalVals) {
        this.computeOriginalValue(predictedVals, 0, corrVals, 0, outOriginalVals, 0);
    }

    public void encodeTransformData(EncoderBuffer buffer) {
    }

    public void decodeTransformData(DecoderBuffer buffer) throws DrakoException {
    }

    public boolean areCorrectionsPositive() {
        return false;
    }
}

