/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointAttributeInfo;
import dev.fileformat.drako.Unsafe;

class PointAttributeVectorOutputIterator {
    byte[] data_;
    private PointAttributeInfo[] attributes_;
    int point_id_;
    private byte[] tmp;

    public PointAttributeVectorOutputIterator(PointAttributeInfo[] atts) {
        this.attributes_ = atts;
        int required_decode_bytes = 0;
        for (int index = 0; index < this.attributes_.length; ++index) {
            PointAttributeInfo att = this.attributes_[index];
            required_decode_bytes = Math.max(required_decode_bytes, att.data_size * att.num_components);
        }
        this.data_ = new byte[required_decode_bytes];
    }

    public void next() {
        ++this.point_id_;
    }

    public void setTriple(byte[] val) {
        PointAttributeInfo att = this.attributes_[0];
        PointAttribute attribute = att.attribute;
        attribute.setAttributeValue(attribute.mappedIndex(this.point_id_), val, att.offset_dimensionality);
    }

    public void set(int[] val) {
        byte[] bytes = this.tmp == null || this.tmp.length != val.length ? new byte[val.length * 4] : this.tmp;
        this.tmp = bytes;
        int offset = 0;
        for (int i = 0; i < val.length; ++i) {
            Unsafe.putLE32(bytes, offset, val[i]);
            offset += 4;
        }
        this.set(bytes);
    }

    public void set(byte[] val) {
        for (int index = 0; index < this.attributes_.length; ++index) {
            int avi;
            PointAttributeInfo att = this.attributes_[index];
            PointAttribute attribute = att.attribute;
            byte[] src = val;
            int src_offset = att.offset_dimensionality;
            if (att.data_size != 4) {
                int dst_offset = 0;
                int i = 0;
                while (i < att.num_components) {
                    System.arraycopy(src, src_offset + i, this.data_, dst_offset, att.data_size);
                    ++i;
                    dst_offset += att.data_size;
                }
                src = this.data_;
                src_offset = 0;
            }
            if ((avi = attribute.mappedIndex(this.point_id_)) >= attribute.getNumUniqueEntries()) {
                return;
            }
            attribute.setAttributeValue(avi, src, 0);
        }
    }
}

