/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.LinearSequencer;
import dev.fileformat.drako.MeshEncoder;
import dev.fileformat.drako.SequentialAttributeEncodersController;

class MeshSequentialEncoder
extends MeshEncoder {
    MeshSequentialEncoder() {
    }

    @Override
    public int getEncodingMethod() {
        return 0;
    }

    @Override
    protected void encodeConnectivity() {
        int numFaces = this.getMesh().getNumFaces();
        Encoding.encodeVarint(numFaces, this.getBuffer());
        Encoding.encodeVarint(this.getMesh().getNumPoints(), this.getBuffer());
        this.getBuffer().encode((byte)1);
        IntSpan face = IntSpan.wrap(new int[3]);
        if (this.getMesh().getNumPoints() < 256) {
            for (int i = 0; i < numFaces; ++i) {
                this.getMesh().readFace(i, face);
                this.getBuffer().encode((byte)face.get(0));
                this.getBuffer().encode((byte)face.get(1));
                this.getBuffer().encode((byte)face.get(2));
            }
        } else if (this.getMesh().getNumPoints() < 65536) {
            for (int i = 0; i < numFaces; ++i) {
                this.getMesh().readFace(i, face);
                this.getBuffer().encode((short)face.get(0));
                this.getBuffer().encode((short)face.get(1));
                this.getBuffer().encode((short)face.get(2));
            }
        } else if (this.getMesh().getNumPoints() < 0x200000) {
            for (int i = 0; i < numFaces; ++i) {
                this.getMesh().readFace(i, face);
                Encoding.encodeVarint(face.get(0), this.buffer);
                Encoding.encodeVarint(face.get(1), this.buffer);
                Encoding.encodeVarint(face.get(2), this.buffer);
            }
        } else {
            for (int i = 0; i < numFaces; ++i) {
                this.getMesh().readFace(i, face);
                this.getBuffer().encode(face);
            }
        }
    }

    @Override
    protected void generateAttributesEncoder(int attId) {
        if (attId == 0) {
            this.addAttributesEncoder(new SequentialAttributeEncodersController(new LinearSequencer(this.getPointCloud().getNumPoints()), attId));
        } else {
            this.attributesEncoder(0).addAttributeId(attId);
        }
    }

    private boolean compressAndEncodeIndices() throws DrakoException {
        int numFaces = this.getMesh().getNumFaces();
        IntSpan indicesBuffer = IntSpan.wrap(new int[3 * numFaces]);
        int lastIndexValue = 0;
        int p = 0;
        IntSpan face = IntSpan.wrap(new int[3]);
        for (int i = 0; i < numFaces; ++i) {
            this.getMesh().readFace(i, face);
            for (int j = 0; j < 3; ++j) {
                int indexValue = face.get(j);
                int indexDiff = indexValue - lastIndexValue;
                int encodedVal = Math.abs(indexDiff) << 1 | (indexDiff < 0 ? 1 : 0);
                indicesBuffer.put(p++, encodedVal);
                lastIndexValue = indexValue;
            }
        }
        Encoding.encodeSymbols(indicesBuffer, indicesBuffer.size(), 1, null, this.getBuffer());
        return true;
    }
}

