/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshPredictionScheme;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.MeshPredictionSchemeParallelogram;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PredictionSchemeTransform;

class MeshPredictionSchemeMultiParallelogram
extends MeshPredictionScheme {
    public MeshPredictionSchemeMultiParallelogram(PointAttribute attribute, PredictionSchemeTransform transform, MeshPredictionSchemeData meshData) {
        super(attribute, transform, meshData);
    }

    @Override
    public int getPredictionMethod() {
        return 2;
    }

    @Override
    public void computeCorrectionValues(IntSpan inData, IntSpan outCorr, int size, int numComponents, int[] entryToPointIdMap) {
        int[] ref0 = new int[1];
        int[] ref1 = new int[1];
        int[] ref2 = new int[1];
        this.transform_.initializeEncoding(inData, numComponents);
        ICornerTable table = this.meshData.getCornerTable();
        int[] vertexToDataMap = this.meshData.vertexToDataMap;
        IntSpan predVals = IntSpan.wrap(new int[numComponents]);
        for (int p = this.meshData.dataToCornerMap.getCount() - 1; p > 0; --p) {
            int startCornerId;
            int cornerId = startCornerId = this.meshData.dataToCornerMap.get(p);
            int numParallelograms = 0;
            for (int i = 0; i < numComponents; ++i) {
                predVals.put(i, 0);
            }
            while (cornerId >= 0) {
                int vertOpp = p;
                int vertNext = p;
                int vertPrev = p;
                int oppCorner = table.opposite(cornerId);
                if (oppCorner >= 0) {
                    ref0[0] = vertOpp;
                    ref1[0] = vertNext;
                    ref2[0] = vertPrev;
                    MeshPredictionScheme.getParallelogramEntries(oppCorner, table, vertexToDataMap, ref0, ref1, ref2);
                    vertOpp = ref0[0];
                    vertNext = ref1[0];
                    vertPrev = ref2[0];
                }
                if (vertOpp < p && vertNext < p && vertPrev < p) {
                    int vOppOff = vertOpp * numComponents;
                    int vNextOff = vertNext * numComponents;
                    int vPrevOff = vertPrev * numComponents;
                    for (int c = 0; c < numComponents; ++c) {
                        predVals.put(c, predVals.get(c) + (inData.get(vNextOff + c) + inData.get(vPrevOff + c) - inData.get(vOppOff + c)));
                    }
                    ++numParallelograms;
                }
                if ((cornerId = table.swingRight(cornerId)) != startCornerId) continue;
                cornerId = -1;
            }
            int dstOffset = p * numComponents;
            if (numParallelograms == 0) {
                int srcOffset = (p - 1) * numComponents;
                this.transform_.computeCorrection(inData, dstOffset, inData, srcOffset, outCorr, 0, dstOffset);
                continue;
            }
            for (int c = 0; c < numComponents; ++c) {
                predVals.put(c, predVals.get(c) / numParallelograms);
            }
            this.transform_.computeCorrection(inData, dstOffset, predVals, 0, outCorr, 0, dstOffset);
        }
        for (int i = 0; i < numComponents; ++i) {
            predVals.put(i, 0);
        }
        this.transform_.computeCorrection(inData, predVals, outCorr, 0);
    }

    @Override
    public void computeOriginalValues(IntSpan inCorr, IntSpan outData, int size, int numComponents, int[] entryToPointIdMap) {
        this.transform_.initializeDecoding(numComponents);
        IntSpan predVals = IntSpan.wrap(new int[numComponents]);
        IntSpan parallelogramPredVals = IntSpan.wrap(new int[numComponents]);
        this.transform_.computeOriginalValue(predVals, inCorr, outData);
        ICornerTable table = this.meshData.getCornerTable();
        int[] vertexToDataMap = this.meshData.vertexToDataMap;
        int cornerMapSize = this.meshData.dataToCornerMap.getCount();
        for (int p = 1; p < cornerMapSize; ++p) {
            int startCornerId;
            int cornerId = startCornerId = this.meshData.dataToCornerMap.get(p);
            int numParallelograms = 0;
            for (int i = 0; i < numComponents; ++i) {
                predVals.put(i, 0);
            }
            while (cornerId != -1) {
                if (MeshPredictionSchemeParallelogram.computeParallelogramPrediction(p, cornerId, table, vertexToDataMap, outData, numComponents, parallelogramPredVals)) {
                    for (int c = 0; c < numComponents; ++c) {
                        predVals.put(c, predVals.get(c) + parallelogramPredVals.get(c));
                    }
                    ++numParallelograms;
                }
                if ((cornerId = table.swingRight(cornerId)) != startCornerId) continue;
                cornerId = -1;
            }
            int dstOffset = p * numComponents;
            if (numParallelograms == 0) {
                int srcOffset = (p - 1) * numComponents;
                this.transform_.computeOriginalValue(outData, srcOffset, inCorr, dstOffset, outData, dstOffset);
                continue;
            }
            for (int c = 0; c < numComponents; ++c) {
                predVals.put(c, predVals.get(c) / numParallelograms);
            }
            this.transform_.computeOriginalValue(predVals, 0, inCorr, dstOffset, outData, dstOffset);
        }
    }
}

