/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.IMeshEdgeBreakerEncoder;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.MeshEdgeBreakerTraversalEncoder;
import dev.fileformat.drako.RAnsBitEncoder;
import java.util.ArrayList;

class MeshEdgeBreakerTraversalPredictiveEncoder
extends MeshEdgeBreakerTraversalEncoder {
    private CornerTable cornerTable;
    private IntList vertexValences;
    private ArrayList<Boolean> predictions;
    private Integer prevSymbol;
    private int numSplitSymbols;
    private int lastCorner;
    private int numSymbols;

    private int computePredictedSymbol(int pivot) {
        int valence = this.vertexValences.get(pivot);
        if (valence < 0) {
            return 9;
        }
        if (valence < 6) {
            return 5;
        }
        return 0;
    }

    @Override
    public void encodeSymbol(int symbol) {
        ++this.numSymbols;
        Integer predictedSymbol = null;
        int next = this.cornerTable.next(this.lastCorner);
        int prev = this.cornerTable.previous(this.lastCorner);
        switch (symbol) {
            case 0: {
                predictedSymbol = this.computePredictedSymbol(this.cornerTable.vertex(next));
                this.vertexValences.set(this.cornerTable.vertex(next), this.vertexValences.get(this.cornerTable.vertex(next)) - 1);
                this.vertexValences.set(this.cornerTable.vertex(prev), this.vertexValences.get(this.cornerTable.vertex(prev)) - 1);
                break;
            }
            case 1: {
                this.vertexValences.set(this.cornerTable.vertex(next), this.vertexValences.get(this.cornerTable.vertex(next)) - 1);
                this.vertexValences.set(this.cornerTable.vertex(prev), this.vertexValences.get(this.cornerTable.vertex(prev)) - 1);
                this.vertexValences.set(this.cornerTable.vertex(this.lastCorner), -1);
                ++this.numSplitSymbols;
                break;
            }
            case 5: {
                predictedSymbol = this.computePredictedSymbol(this.cornerTable.vertex(next));
                this.vertexValences.set(this.cornerTable.vertex(this.lastCorner), this.vertexValences.get(this.cornerTable.vertex(this.lastCorner)) - 1);
                this.vertexValences.set(this.cornerTable.vertex(next), this.vertexValences.get(this.cornerTable.vertex(next)) - 1);
                this.vertexValences.set(this.cornerTable.vertex(prev), this.vertexValences.get(this.cornerTable.vertex(prev)) - 2);
                break;
            }
            case 3: {
                this.vertexValences.set(this.cornerTable.vertex(this.lastCorner), this.vertexValences.get(this.cornerTable.vertex(this.lastCorner)) - 1);
                this.vertexValences.set(this.cornerTable.vertex(next), this.vertexValences.get(this.cornerTable.vertex(next)) - 2);
                this.vertexValences.set(this.cornerTable.vertex(prev), this.vertexValences.get(this.cornerTable.vertex(prev)) - 1);
                break;
            }
            case 7: {
                this.vertexValences.set(this.cornerTable.vertex(this.lastCorner), this.vertexValences.get(this.cornerTable.vertex(this.lastCorner)) - 2);
                this.vertexValences.set(this.cornerTable.vertex(next), this.vertexValences.get(this.cornerTable.vertex(next)) - 2);
                this.vertexValences.set(this.cornerTable.vertex(prev), this.vertexValences.get(this.cornerTable.vertex(prev)) - 2);
                break;
            }
        }
        boolean storePrevSymbol = true;
        if (predictedSymbol != null && this.prevSymbol != null) {
            if (predictedSymbol.intValue() == this.prevSymbol.intValue()) {
                this.predictions.add(true);
                storePrevSymbol = false;
            } else {
                this.predictions.add(false);
            }
        }
        if (storePrevSymbol && this.prevSymbol != null) {
            super.encodeSymbol(this.prevSymbol);
        }
        this.prevSymbol = symbol;
    }

    @Override
    public void newCornerReached(int corner) {
        this.lastCorner = corner;
    }

    @Override
    public void done() {
        if (this.prevSymbol != null) {
            super.encodeSymbol(this.prevSymbol);
        }
        super.done();
        this.getOutputBuffer().encode2(this.numSplitSymbols);
        RAnsBitEncoder predictionEncoder = new RAnsBitEncoder();
        predictionEncoder.startEncoding();
        for (int i = this.predictions.size() - 1; i >= 0; --i) {
            predictionEncoder.encodeBit(this.predictions.get(i));
        }
        predictionEncoder.endEncoding(this.getOutputBuffer());
    }

    @Override
    public void init(IMeshEdgeBreakerEncoder encoder) {
        super.init(encoder);
        this.cornerTable = encoder.getCornerTable();
        this.vertexValences.resize(this.cornerTable.getNumVertices(), 0);
        for (int i = 0; i < this.vertexValences.getCount(); ++i) {
            this.vertexValences.set(i, this.cornerTable.valence(i));
        }
    }

    @Override
    public int getNumEncodedSymbols() {
        return this.numSymbols;
    }

    public MeshEdgeBreakerTraversalPredictiveEncoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.vertexValences = new IntList();
            this.predictions = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

