/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.CornerTable;
import dev.fileformat.drako.DepthFirstTraverser;
import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EdgeBreakerTraverser;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.HoleEventData;
import dev.fileformat.drako.IMeshEdgeBreakerEncoder;
import dev.fileformat.drako.ITraversalEncoder;
import dev.fileformat.drako.Int2D;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.MeshAttributeCornerTable;
import dev.fileformat.drako.MeshAttributeIndicesEncodingData;
import dev.fileformat.drako.MeshAttributeIndicesEncodingObserver;
import dev.fileformat.drako.MeshEdgeBreakerEncoder;
import dev.fileformat.drako.MeshTraversalSequencer;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.SequentialAttributeEncodersController;
import dev.fileformat.drako.TopologySplitEventData;
import dev.fileformat.drako.TraverserBase;
import java.util.ArrayList;
import java.util.HashMap;

class MeshEdgeBreakerEncoderImpl
implements IMeshEdgeBreakerEncoder {
    private MeshEdgeBreakerEncoder encoder;
    private DracoMesh mesh;
    private CornerTable cornerTable;
    private IntList cornerTraversalStack;
    private ArrayList<Boolean> visitedFaces;
    private MeshAttributeIndicesEncodingData posEncodingData;
    private IntList processedConnectivityCorners;
    private boolean[] visitedVertexIds;
    private IntList vertexTraversalLength;
    private ArrayList<TopologySplitEventData> topologySplitEventData;
    private HashMap<Integer, Integer> faceToSplitSymbolMap;
    private ArrayList<Boolean> visitedHoles;
    private int[] vertexHoleId;
    private ArrayList<HoleEventData> holeEventData;
    private int lastEncodedSymbolId;
    private int numSplitSymbols;
    private AttributeData[] attributeData;
    private byte posTraversalMethod;
    private IntList attributeEncoderToDataIdMap;
    private ITraversalEncoder traversalEncoder;

    public void initAttributeData() {
        int numAttributes = this.mesh.getNumAttributes();
        this.attributeData = new AttributeData[numAttributes - 1];
        for (int i = 0; i < this.attributeData.length; ++i) {
            this.attributeData[i] = new AttributeData();
        }
        if (numAttributes == 1) {
            return;
        }
        int dataIndex = 0;
        for (int i = 0; i < numAttributes; ++i) {
            int attIndex = i;
            if (this.mesh.attribute(attIndex).getAttributeType() == 0) continue;
            PointAttribute att = this.mesh.attribute(attIndex);
            this.attributeData[dataIndex].attributeIndex = attIndex;
            this.attributeData[dataIndex].encodingData.encodedAttributeValueIndexToCornerMap.clear();
            this.attributeData[dataIndex].encodingData.encodedAttributeValueIndexToCornerMap.setCapacity(this.cornerTable.getNumCorners());
            this.attributeData[dataIndex].encodingData.vertexToEncodedAttributeValueIndexMap = new int[this.cornerTable.getNumCorners()];
            DracoUtils.fill(this.attributeData[dataIndex].encodingData.vertexToEncodedAttributeValueIndexMap, -1);
            this.attributeData[dataIndex].encodingData.numValues = 0;
            this.attributeData[dataIndex].connectivityData = new MeshAttributeCornerTable(this.mesh, this.cornerTable, att);
            ++dataIndex;
        }
    }

    private void assign(IntList list, int size, int val) {
        while (list.getCount() > size) {
            list.removeAt(list.getCount() - 1);
        }
        for (int i = 0; i < list.getCount(); ++i) {
            list.set(i, val);
        }
        while (list.getCount() < size) {
            list.add(val);
        }
    }

    private <T> void assign(ArrayList<T> list, int size, T val) {
        while (list.size() > size) {
            list.remove(list.size() - 1);
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, val);
        }
        while (list.size() < size) {
            list.add(val);
        }
    }

    public boolean findInitFaceConfiguration(int faceId, int[] outCorner) {
        int cornerIndex = 3 * faceId;
        for (int i = 0; i < 3; ++i) {
            if (this.cornerTable.opposite(cornerIndex) == -1) {
                outCorner[0] = cornerIndex;
                return false;
            }
            if (this.vertexHoleId[this.cornerTable.vertex(cornerIndex)] != -1) {
                int rightCorner = cornerIndex;
                while (rightCorner >= 0) {
                    cornerIndex = rightCorner;
                    rightCorner = this.cornerTable.swingRight(rightCorner);
                }
                outCorner[0] = this.cornerTable.previous(cornerIndex);
                return false;
            }
            cornerIndex = this.cornerTable.next(cornerIndex);
        }
        outCorner[0] = cornerIndex;
        return true;
    }

    public void encodeConnectivityFromCorner(int cornerId) {
        this.cornerTraversalStack.clear();
        this.cornerTraversalStack.add(cornerId);
        int numFaces = this.mesh.getNumFaces();
        block0: while (this.cornerTraversalStack.getCount() > 0) {
            cornerId = this.cornerTraversalStack.get(this.cornerTraversalStack.getCount() - 1);
            if (cornerId < 0 || this.visitedFaces.get(this.cornerTable.face(cornerId)).booleanValue()) {
                this.cornerTraversalStack.removeAt(this.cornerTraversalStack.getCount() - 1);
                continue;
            }
            int numVisitedFaces = 0;
            while (numVisitedFaces < numFaces) {
                int holeId;
                boolean onBoundary;
                ++numVisitedFaces;
                ++this.lastEncodedSymbolId;
                int faceId = this.cornerTable.face(cornerId);
                this.visitedFaces.set(faceId, true);
                this.processedConnectivityCorners.add(cornerId);
                this.traversalEncoder.newCornerReached(cornerId);
                int vertId = this.cornerTable.vertex(cornerId);
                boolean bl = onBoundary = this.vertexHoleId[vertId] != -1;
                if (!this.isVertexVisited(vertId)) {
                    this.visitedVertexIds[vertId] = true;
                    if (!onBoundary) {
                        this.traversalEncoder.encodeSymbol(0);
                        cornerId = this.getRightCorner(cornerId);
                        continue;
                    }
                }
                int rightCornerId = this.getRightCorner(cornerId);
                int leftCornerId = this.getLeftCorner(cornerId);
                int rightFaceId = this.cornerTable.face(rightCornerId);
                int leftFaceId = this.cornerTable.face(leftCornerId);
                if (this.isRightFaceVisited(cornerId)) {
                    if (rightFaceId != -1) {
                        this.checkAndStoreTopologySplitEvent(this.lastEncodedSymbolId, faceId, (byte)1, rightFaceId);
                    }
                    if (this.isLeftFaceVisited(cornerId)) {
                        if (leftFaceId != -1) {
                            this.checkAndStoreTopologySplitEvent(this.lastEncodedSymbolId, faceId, (byte)0, leftFaceId);
                        }
                        this.traversalEncoder.encodeSymbol(7);
                        this.cornerTraversalStack.removeAt(this.cornerTraversalStack.getCount() - 1);
                        continue block0;
                    }
                    this.traversalEncoder.encodeSymbol(5);
                    cornerId = leftCornerId;
                    continue;
                }
                if (this.isLeftFaceVisited(cornerId)) {
                    if (leftFaceId != -1) {
                        this.checkAndStoreTopologySplitEvent(this.lastEncodedSymbolId, faceId, (byte)0, leftFaceId);
                    }
                    this.traversalEncoder.encodeSymbol(3);
                    cornerId = rightCornerId;
                    continue;
                }
                this.traversalEncoder.encodeSymbol(1);
                ++this.numSplitSymbols;
                if (onBoundary && !this.visitedHoles.get(holeId = this.vertexHoleId[vertId]).booleanValue()) {
                    this.encodeHole(cornerId, false);
                    this.holeEventData.add(new HoleEventData(this.lastEncodedSymbolId));
                }
                this.faceToSplitSymbolMap.put(faceId, this.lastEncodedSymbolId);
                this.cornerTraversalStack.set(this.cornerTraversalStack.getCount() - 1, leftCornerId);
                this.cornerTraversalStack.add(rightCornerId);
                continue block0;
            }
        }
    }

    public int encodeHole(int startCornerId, boolean encodeFirstVertex) {
        int cornerId = startCornerId;
        cornerId = this.cornerTable.previous(cornerId);
        while (this.cornerTable.opposite(cornerId) != -1) {
            cornerId = this.cornerTable.opposite(cornerId);
            cornerId = this.cornerTable.next(cornerId);
        }
        int startVertexId = this.cornerTable.vertex(startCornerId);
        int numEncodedHoleVerts = 0;
        if (encodeFirstVertex) {
            this.visitedVertexIds[startVertexId] = true;
            ++numEncodedHoleVerts;
        }
        this.visitedHoles.set(this.vertexHoleId[startVertexId], true);
        int startVertId = this.cornerTable.vertex(this.cornerTable.next(cornerId));
        int actVertexId = this.cornerTable.vertex(this.cornerTable.previous(cornerId));
        while (actVertexId != startVertexId) {
            startVertId = actVertexId;
            this.visitedVertexIds[actVertexId] = true;
            ++numEncodedHoleVerts;
            cornerId = this.cornerTable.next(cornerId);
            while (this.cornerTable.opposite(cornerId) != -1) {
                cornerId = this.cornerTable.opposite(cornerId);
                cornerId = this.cornerTable.next(cornerId);
            }
            actVertexId = this.cornerTable.vertex(this.cornerTable.previous(cornerId));
        }
        return numEncodedHoleVerts;
    }

    public int getRightCorner(int cornerId) {
        int nextCornerId = this.cornerTable.next(cornerId);
        return this.cornerTable.opposite(nextCornerId);
    }

    public int getLeftCorner(int cornerId) {
        int prevCornerId = this.cornerTable.previous(cornerId);
        return this.cornerTable.opposite(prevCornerId);
    }

    public boolean isRightFaceVisited(int cornerId) {
        int nextCornerId = this.cornerTable.next(cornerId);
        int oppCornerId = this.cornerTable.opposite(nextCornerId);
        if (oppCornerId != -1) {
            return this.visitedFaces.get(this.cornerTable.face(oppCornerId));
        }
        return true;
    }

    public boolean isLeftFaceVisited(int cornerId) {
        int prevCornerId = this.cornerTable.previous(cornerId);
        int oppCornerId = this.cornerTable.opposite(prevCornerId);
        if (oppCornerId != -1) {
            return this.visitedFaces.get(this.cornerTable.face(oppCornerId));
        }
        return true;
    }

    public boolean isVertexVisited(int vertId) {
        return this.visitedVertexIds[vertId];
    }

    public boolean findHoles() {
        int numCorners = this.cornerTable.getNumCorners();
        for (int i = 0; i < numCorners; ++i) {
            int boundaryVertId;
            if (this.cornerTable.isDegenerated(this.cornerTable.face(i)) || this.cornerTable.opposite(i) != -1 || this.vertexHoleId[boundaryVertId = this.cornerTable.vertex(this.cornerTable.next(i))] != -1) continue;
            int boundaryId = this.visitedHoles.size();
            this.visitedHoles.add(false);
            int cornerId = i;
            while (this.vertexHoleId[boundaryVertId] == -1) {
                this.vertexHoleId[boundaryVertId] = boundaryId;
                cornerId = this.cornerTable.next(cornerId);
                while (this.cornerTable.opposite(cornerId) != -1) {
                    cornerId = this.cornerTable.opposite(cornerId);
                    cornerId = this.cornerTable.next(cornerId);
                }
                boundaryVertId = this.cornerTable.vertex(this.cornerTable.next(cornerId));
            }
        }
        return true;
    }

    public int getSplitSymbolIdOnFace(int faceId) {
        Integer[] ref0 = new Integer[1];
        if (AsposeUtils.tryGetValue(this.faceToSplitSymbolMap, Integer.valueOf(faceId), ref0)) {
            int ret = ref0[0] == null ? 0 : ref0[0];
            return ret;
        }
        int ret = ref0[0] == null ? 0 : ref0[0];
        return -1;
    }

    public void checkAndStoreTopologySplitEvent(int srcSymbolId, int srcFaceId, byte srcEdge, int neighborFaceId) {
        int symbolId = this.getSplitSymbolIdOnFace(neighborFaceId);
        if (symbolId == -1) {
            return;
        }
        TopologySplitEventData eventData = new TopologySplitEventData();
        eventData.splitSymbolId = symbolId;
        eventData.splitEdge = 0;
        eventData.sourceSymbolId = srcSymbolId;
        eventData.sourceEdge = srcEdge;
        this.topologySplitEventData.add(eventData);
    }

    public void encodeAttributeConnectivitiesOnFace(int corner) {
        int[] corners = new int[]{corner, this.cornerTable.next(corner), this.cornerTable.previous(corner)};
        int src_face_id = this.cornerTable.face(corner);
        this.visitedFaces.set(src_face_id, true);
        for (int c = 0; c < 3; ++c) {
            int opp_face_id;
            int oppCorner = this.cornerTable.opposite(corners[c]);
            if (oppCorner < 0 || this.visitedFaces.get(opp_face_id = this.cornerTable.face(oppCorner)).booleanValue()) continue;
            for (int i = 0; i < this.attributeData.length; ++i) {
                if (this.attributeData[i].connectivityData.isCornerOppositeToSeamEdge(corners[c])) {
                    this.traversalEncoder.encodeAttributeSeam(i, true);
                    continue;
                }
                this.traversalEncoder.encodeAttributeSeam(i, false);
            }
        }
    }

    public MeshEdgeBreakerEncoderImpl(ITraversalEncoder encoder) {
        this.$initFields$();
        this.lastEncodedSymbolId = -1;
        this.traversalEncoder = encoder;
    }

    @Override
    public void init(MeshEdgeBreakerEncoder encoder) {
        this.encoder = encoder;
        this.mesh = encoder.getMesh();
        this.attributeEncoderToDataIdMap.clear();
    }

    @Override
    public MeshAttributeCornerTable getAttributeCornerTable(int attId) {
        for (int i = 0; i < this.attributeData.length; ++i) {
            if (this.attributeData[i].attributeIndex != attId) continue;
            if (this.attributeData[i].isConnectivityUsed) {
                return this.attributeData[i].connectivityData;
            }
            return null;
        }
        return null;
    }

    @Override
    public MeshAttributeIndicesEncodingData getAttributeEncodingData(int attId) {
        for (int i = 0; i < this.attributeData.length; ++i) {
            if (this.attributeData[i].attributeIndex != attId) continue;
            return this.attributeData[i].encodingData;
        }
        return this.posEncodingData;
    }

    @Override
    public void generateAttributesEncoder(int attId) throws DrakoException {
        int elementType = this.getEncoder().getMesh().getAttributeElementType(attId);
        PointAttribute att = this.getEncoder().getPointCloud().attribute(attId);
        int attDataId = -1;
        for (int i = 0; i < this.attributeData.length; ++i) {
            if (this.attributeData[i].attributeIndex != attId) continue;
            attDataId = i;
            break;
        }
        byte traversalMethod = 0;
        MeshTraversalSequencer<CornerTable> sequencer = null;
        if (att.getAttributeType() == 0 || elementType == 0 || elementType == 1 && this.attributeData[attDataId].connectivityData.getNoInteriorSeams()) {
            MeshAttributeIndicesEncodingData encodingData;
            if (att.getAttributeType() == 0) {
                encodingData = this.posEncodingData;
            } else {
                encodingData = this.attributeData[attDataId].encodingData;
                this.attributeData[attDataId].isConnectivityUsed = false;
            }
            int speed = this.encoder.getOptions().getSpeed();
            if (speed == 0 && att.getAttributeType() == 0) {
                traversalMethod = 1;
                if (this.mesh.getNumAttributes() > 1) {
                    traversalMethod = 0;
                }
            }
            MeshTraversalSequencer<CornerTable> traversalSequencer = new MeshTraversalSequencer<CornerTable>(this.mesh, encodingData);
            MeshAttributeIndicesEncodingObserver<CornerTable> attObserver = new MeshAttributeIndicesEncodingObserver<CornerTable>(this.cornerTable, this.mesh, traversalSequencer, encodingData);
            TraverserBase attTraverser = null;
            if (traversalMethod == 1) {
                attTraverser = new EdgeBreakerTraverser<CornerTable>(this.cornerTable, attObserver);
            } else if (traversalMethod == 0) {
                attTraverser = new DepthFirstTraverser(this.cornerTable, attObserver);
            }
            traversalSequencer.setCornerOrder(this.processedConnectivityCorners);
            traversalSequencer.setTraverser(attTraverser);
            sequencer = traversalSequencer;
        } else {
            MeshTraversalSequencer<MeshAttributeCornerTable> traversalSequencer = new MeshTraversalSequencer<MeshAttributeCornerTable>(this.mesh, this.attributeData[attDataId].encodingData);
            MeshAttributeIndicesEncodingObserver<MeshAttributeCornerTable> attObserver = new MeshAttributeIndicesEncodingObserver<MeshAttributeCornerTable>(this.attributeData[attDataId].connectivityData, this.mesh, traversalSequencer, this.attributeData[attDataId].encodingData);
            EdgeBreakerTraverser<MeshAttributeCornerTable> attTraverser = new EdgeBreakerTraverser<MeshAttributeCornerTable>(this.attributeData[attDataId].connectivityData, attObserver);
            traversalSequencer.setCornerOrder(this.processedConnectivityCorners);
            traversalSequencer.setTraverser(attTraverser);
            sequencer = traversalSequencer;
        }
        if (sequencer == null) {
            throw DracoUtils.failed();
        }
        if (attDataId == -1) {
            this.posTraversalMethod = traversalMethod;
        } else {
            this.attributeData[attDataId].traversalMethod = traversalMethod;
        }
        SequentialAttributeEncodersController attController = new SequentialAttributeEncodersController(sequencer, attId);
        this.attributeEncoderToDataIdMap.add(attDataId);
        this.getEncoder().addAttributesEncoder(attController);
    }

    @Override
    public void encodeAttributesEncoderIdentifier(int attEncoderId) {
        byte traversalMethod;
        int attDataId = this.attributeEncoderToDataIdMap.get(attEncoderId);
        this.encoder.getBuffer().encode((byte)attDataId);
        int elementType = 0;
        if (attDataId >= 0) {
            int attId = this.attributeData[attDataId].attributeIndex;
            elementType = this.getEncoder().getMesh().getAttributeElementType(attId);
            traversalMethod = this.attributeData[attDataId].traversalMethod;
        } else {
            traversalMethod = this.posTraversalMethod;
        }
        if (elementType == 0 || elementType == 1 && this.attributeData[attDataId].connectivityData.getNoInteriorSeams()) {
            this.encoder.getBuffer().encode((byte)0);
        } else {
            this.encoder.getBuffer().encode((byte)1);
        }
        this.encoder.getBuffer().encode(traversalMethod);
    }

    private CornerTable createCornerTableFromPositionAttribute(DracoMesh mesh) {
        PointAttribute att = mesh.getNamedAttribute(0);
        if (att == null) {
            return null;
        }
        Int2D faces = new Int2D(mesh.getNumFaces(), 3);
        IntSpan face = IntSpan.wrap(new int[3]);
        for (int i = 0; i < mesh.getNumFaces(); ++i) {
            mesh.readFace(i, face);
            for (int j = 0; j < 3; ++j) {
                faces.set(i, j, att.mappedIndex(face.get(j)));
            }
        }
        CornerTable ret = new CornerTable();
        ret.initialize(faces);
        return ret;
    }

    private CornerTable createCornerTableFromAllAttributes(DracoMesh mesh) {
        Int2D faces = new Int2D(mesh.getNumFaces(), 3);
        IntSpan face = IntSpan.wrap(new int[3]);
        for (int i = 0; i < mesh.getNumFaces(); ++i) {
            mesh.readFace(i, face);
            for (int j = 0; j < 3; ++j) {
                faces.set(i, j, face.get(j));
            }
        }
        CornerTable ret = new CornerTable();
        ret.initialize(faces);
        return ret;
    }

    @Override
    public void encodeConnectivity() throws DrakoException {
        int[] ref1 = new int[1];
        this.cornerTable = this.encoder.getOptions().getSplitMeshOnSeams() ? this.createCornerTableFromAllAttributes(this.mesh) : this.createCornerTableFromPositionAttribute(this.mesh);
        if (this.cornerTable == null || this.cornerTable.getNumFaces() == this.cornerTable.getNumDegeneratedFaces()) {
            throw DracoUtils.failed();
        }
        this.traversalEncoder.init(this);
        int numVerticesToBeEncoded = this.cornerTable.getNumVertices() - this.cornerTable.getNumIsolatedVertices();
        Encoding.encodeVarint2(numVerticesToBeEncoded, this.getEncoder().getBuffer());
        int numFaces = this.cornerTable.getNumFaces() - this.cornerTable.getNumDegeneratedFaces();
        Encoding.encodeVarint2(numFaces, this.getEncoder().getBuffer());
        this.assign(this.visitedFaces, this.mesh.getNumFaces(), false);
        this.posEncodingData.vertexToEncodedAttributeValueIndexMap = new int[this.cornerTable.getNumVertices()];
        DracoUtils.fill(this.posEncodingData.vertexToEncodedAttributeValueIndexMap, -1);
        this.posEncodingData.encodedAttributeValueIndexToCornerMap.clear();
        this.posEncodingData.encodedAttributeValueIndexToCornerMap.setCapacity(this.cornerTable.getNumFaces() * 3);
        this.visitedVertexIds = new boolean[this.cornerTable.getNumVertices()];
        this.vertexTraversalLength.clear();
        this.lastEncodedSymbolId = -1;
        this.numSplitSymbols = 0;
        this.topologySplitEventData.clear();
        this.faceToSplitSymbolMap.clear();
        this.visitedHoles.clear();
        this.vertexHoleId = new int[this.cornerTable.getNumVertices()];
        DracoUtils.fill(this.vertexHoleId, -1);
        this.holeEventData.clear();
        this.processedConnectivityCorners.clear();
        this.processedConnectivityCorners.setCapacity(this.cornerTable.getNumFaces());
        this.posEncodingData.numValues = 0;
        if (!this.findHoles()) {
            throw DracoUtils.failed();
        }
        this.initAttributeData();
        byte numAttributeData = (byte)this.attributeData.length;
        this.encoder.getBuffer().encode(numAttributeData);
        int numCorners = this.cornerTable.getNumCorners();
        this.traversalEncoder.start();
        IntList initFaceConnectivityCorners = new IntList();
        for (int cId = 0; cId < numCorners; ++cId) {
            int cornerIndex = cId;
            int faceId = this.cornerTable.face(cornerIndex);
            if (this.visitedFaces.get(faceId).booleanValue() || this.cornerTable.isDegenerated(faceId)) continue;
            boolean interiorConfig = this.findInitFaceConfiguration(faceId, ref1);
            int startCorner = ref1[0];
            this.traversalEncoder.encodeStartFaceConfiguration(interiorConfig);
            if (interiorConfig) {
                cornerIndex = startCorner;
                int vertId = this.cornerTable.vertex(cornerIndex);
                int nextVertId = this.cornerTable.vertex(this.cornerTable.next(cornerIndex));
                int prevVertId = this.cornerTable.vertex(this.cornerTable.previous(cornerIndex));
                this.visitedVertexIds[vertId] = true;
                this.visitedVertexIds[nextVertId] = true;
                this.visitedVertexIds[prevVertId] = true;
                this.vertexTraversalLength.add(1);
                this.visitedFaces.set(faceId, true);
                initFaceConnectivityCorners.add(this.cornerTable.next(cornerIndex));
                int oppId = this.cornerTable.opposite(this.cornerTable.next(cornerIndex));
                int oppFaceId = this.cornerTable.face(oppId);
                if (oppFaceId == -1 || this.visitedFaces.get(oppFaceId).booleanValue()) continue;
                this.encodeConnectivityFromCorner(oppId);
                continue;
            }
            this.encodeHole(this.cornerTable.next(startCorner), true);
            this.encodeConnectivityFromCorner(startCorner);
        }
        this.processedConnectivityCorners.reverse();
        this.processedConnectivityCorners.addRange(initFaceConnectivityCorners);
        if (this.attributeData.length > 0) {
            int i;
            for (i = 0; i < this.visitedFaces.size(); ++i) {
                this.visitedFaces.set(i, false);
            }
            for (i = 0; i < this.processedConnectivityCorners.getCount(); ++i) {
                int ci = this.processedConnectivityCorners.get(i);
                this.encodeAttributeConnectivitiesOnFace(ci);
            }
        }
        this.traversalEncoder.done();
        Encoding.encodeVarint2(this.traversalEncoder.getNumEncodedSymbols(), this.encoder.getBuffer());
        Encoding.encodeVarint2(this.numSplitSymbols, this.encoder.getBuffer());
        this.encodeSplitData();
        this.encoder.getBuffer().encode(this.traversalEncoder.getBuffer().getData(), this.traversalEncoder.getBuffer().getBytes());
    }

    void encodeSplitData() {
        int numEvents = this.topologySplitEventData.size();
        Encoding.encodeVarint2(numEvents, this.encoder.getBuffer());
        if (numEvents > 0) {
            TopologySplitEventData event_data;
            int i;
            int last_source_symbol_id = 0;
            for (i = 0; i < numEvents; ++i) {
                event_data = this.topologySplitEventData.get(i);
                Encoding.encodeVarint2(event_data.sourceSymbolId - last_source_symbol_id, this.encoder.getBuffer());
                Encoding.encodeVarint2(event_data.sourceSymbolId - event_data.splitSymbolId, this.encoder.getBuffer());
                last_source_symbol_id = event_data.sourceSymbolId;
            }
            this.encoder.getBuffer().startBitEncoding(numEvents, false);
            for (i = 0; i < numEvents; ++i) {
                event_data = this.topologySplitEventData.get(i);
                this.encoder.getBuffer().encodeLeastSignificantBits32(1, 0xFF & event_data.sourceEdge);
            }
            this.encoder.getBuffer().endBitEncoding();
        }
    }

    @Override
    public CornerTable getCornerTable() {
        return this.cornerTable;
    }

    @Override
    public MeshEdgeBreakerEncoder getEncoder() {
        return this.encoder;
    }

    private void $initFields$() {
        try {
            this.cornerTraversalStack = new IntList();
            this.visitedFaces = new ArrayList();
            this.posEncodingData = new MeshAttributeIndicesEncodingData();
            this.processedConnectivityCorners = new IntList();
            this.vertexTraversalLength = new IntList();
            this.topologySplitEventData = new ArrayList();
            this.faceToSplitSymbolMap = new HashMap();
            this.visitedHoles = new ArrayList();
            this.holeEventData = new ArrayList();
            this.attributeData = null;
            this.attributeEncoderToDataIdMap = new IntList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assign(ArrayList<Boolean> list, int size, boolean val) {
        while (list.size() > size) {
            list.remove(list.size() - 1);
        }
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, val);
        }
        while (list.size() < size) {
            list.add(val);
        }
    }

    static class AttributeData {
        public int attributeIndex = -1;
        public MeshAttributeCornerTable connectivityData;
        public boolean isConnectivityUsed = true;
        public MeshAttributeIndicesEncodingData encodingData = new MeshAttributeIndicesEncodingData();
        public byte traversalMethod;

        AttributeData() {
        }
    }
}

