/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeQuantizationTransform;
import dev.fileformat.drako.AttributesEncoder;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.DynamicIntegerPointsKdTreeEncoder;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.Unsafe;
import java.util.ArrayList;

class KdTreeAttributesEncoder
extends AttributesEncoder {
    private ArrayList<AttributeQuantizationTransform> attribute_quantization_transforms_;
    private IntList min_signed_values_;
    private ArrayList<PointAttribute> quantized_portable_attributes_;
    private int num_components_;

    public KdTreeAttributesEncoder(int attId) {
        super(attId);
        this.$initFields$();
    }

    @Override
    public byte getUniqueId() {
        return 2;
    }

    @Override
    protected void transformAttributesToPortableFormat() throws DrakoException {
        PointAttribute att;
        int att_id;
        int i;
        int num_points = this.getEncoder().getPointCloud().getNumPoints();
        int num_components = 0;
        int[] ref0 = new int[1];
        for (i = 0; i < this.getNumAttributes(); ++i) {
            att_id = this.getAttributeId(i);
            att = this.getEncoder().getPointCloud().attribute(att_id);
            num_components += att.getComponentsCount();
        }
        this.num_components_ = num_components;
        for (i = 0; i < this.getNumAttributes(); ++i) {
            att_id = this.getAttributeId(i);
            att = this.getEncoder().getPointCloud().attribute(att_id);
            if (att.getDataType() == 9) {
                AttributeQuantizationTransform attribute_quantization_transform = new AttributeQuantizationTransform();
                int quantization_bits = this.getEncoder().getOptions().getQuantizationBits(att);
                if (quantization_bits < 1) {
                    throw DracoUtils.failed();
                }
                attribute_quantization_transform.computeParameters(att, quantization_bits);
                this.attribute_quantization_transforms_.add(attribute_quantization_transform);
                PointAttribute portable_att = attribute_quantization_transform.initTransformedAttribute(att, num_points);
                attribute_quantization_transform.generatePortableAttribute(att, num_points, portable_att);
                this.quantized_portable_attributes_.add(portable_att);
                continue;
            }
            if (att.getDataType() != 5 && att.getDataType() != 3 && att.getDataType() != 1) continue;
            int[] min_value = new int[att.getComponentsCount()];
            for (int j = 0; j < min_value.length; ++j) {
                min_value[j] = Integer.MAX_VALUE;
            }
            int[] act_value = new int[att.getComponentsCount()];
            for (int avi = 0; avi < att.getNumUniqueEntries(); ++avi) {
                att.convertValue(avi, ref0);
                act_value[0] = ref0[0];
                for (int c = 0; c < att.getComponentsCount(); ++c) {
                    if (min_value[c] <= act_value[c]) continue;
                    min_value[c] = act_value[c];
                }
            }
            for (int c = 0; c < att.getComponentsCount(); ++c) {
                this.min_signed_values_.add(min_value[c]);
            }
        }
    }

    @Override
    protected void encodePortableAttributes(EncoderBuffer out_buffer) throws DrakoException {
        int compression_level = Math.min(10 - this.getEncoder().getOptions().getSpeed(), 6);
        int[] ref1 = new int[1];
        int[] ref2 = new int[1];
        if (compression_level == 6 && this.num_components_ > 15) {
            compression_level = 5;
        }
        out_buffer.encode((byte)compression_level);
        int num_points = this.getEncoder().getPointCloud().getNumPoints();
        int[][] point_vector = new int[num_points][];
        for (int i = 0; i < num_points; ++i) {
            point_vector[i] = new int[this.num_components_];
        }
        int num_processed_components = 0;
        int num_processed_quantized_attributes = 0;
        int num_processed_signed_components = 0;
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            int att_id = this.getAttributeId(i);
            PointAttribute att = this.getEncoder().getPointCloud().attribute(att_id);
            PointAttribute source_att = null;
            if (att.getDataType() == 6 || att.getDataType() == 4 || att.getDataType() == 2 || att.getDataType() == 5 || att.getDataType() == 3 || att.getDataType() == 1) {
                source_att = att;
            } else if (att.getDataType() == 9) {
                source_att = this.quantized_portable_attributes_.get(num_processed_quantized_attributes);
                ++num_processed_quantized_attributes;
            } else {
                throw DracoUtils.failed();
            }
            if (source_att == null) {
                throw DracoUtils.failed();
            }
            if (source_att.getDataType() == 6) {
                for (int pi = 0; pi < num_points; ++pi) {
                    int avi = source_att.mappedIndex(pi);
                    int offset = source_att.getBytePos(avi);
                    this.copyAttribute(point_vector, source_att.getComponentsCount(), num_processed_components, pi, source_att.getBuffer().getBuffer(), offset);
                }
            } else if (source_att.getDataType() == 5 || source_att.getDataType() == 3 || source_att.getDataType() == 1) {
                int[] signed_point = new int[source_att.getComponentsCount()];
                int[] unsigned_point = new int[source_att.getComponentsCount()];
                for (int pi = 0; pi < num_points; ++pi) {
                    int avi = source_att.mappedIndex(pi);
                    source_att.convertValue(avi, ref1);
                    signed_point[0] = ref1[0];
                    for (int c = 0; c < source_att.getComponentsCount(); ++c) {
                        unsigned_point[c] = signed_point[c] - this.min_signed_values_.get(num_processed_signed_components + c);
                    }
                    this.copyAttribute(point_vector, num_processed_components, pi, unsigned_point);
                }
                num_processed_signed_components += source_att.getComponentsCount();
            } else {
                int[] point = new int[source_att.getComponentsCount()];
                for (int pi = 0; pi < num_points; ++pi) {
                    int avi = source_att.mappedIndex(pi);
                    source_att.convertValue(avi, ref2);
                    point[0] = ref2[0];
                    this.copyAttribute(point_vector, num_processed_components, pi, point);
                }
            }
            num_processed_components += source_att.getComponentsCount();
        }
        int num_bits = 0;
        for (int r = 0; r < num_points; ++r) {
            for (int c = 0; c < this.num_components_; ++c) {
                int msb;
                if (point_vector[r][c] <= 0 || (msb = DracoUtils.mostSignificantBit(point_vector[r][c]) + 1) <= num_bits) continue;
                num_bits = msb;
            }
        }
        DynamicIntegerPointsKdTreeEncoder points_encoder = new DynamicIntegerPointsKdTreeEncoder(0xFF & compression_level, this.num_components_);
        points_encoder.encodePoints(point_vector, num_bits, out_buffer);
    }

    @Override
    protected void encodeDataNeededByPortableTransforms(EncoderBuffer out_buffer) throws DrakoException {
        int i;
        for (i = 0; i < this.attribute_quantization_transforms_.size(); ++i) {
            this.attribute_quantization_transforms_.get(i).encodeParameters(out_buffer);
        }
        for (i = 0; i < this.min_signed_values_.getCount(); ++i) {
            Encoding.encodeVarint(this.min_signed_values_.get(i), out_buffer);
        }
    }

    void copyAttribute(int[][] attribute, int offset_dimensionality, int index, int[] attribute_item_data) {
        int copy_size = attribute_item_data.length;
        int[] face = attribute[index];
        int j = offset_dimensionality;
        int i = 0;
        while (i < copy_size) {
            face[j] = attribute_item_data[i];
            ++i;
            ++j;
        }
    }

    void copyAttribute(int[][] attribute, int attribute_dimensionality, int offset_dimensionality, int index, byte[] attribute_item_data, int offset) {
        int copy_size = attribute_dimensionality;
        int[] face = attribute[index];
        int j = offset_dimensionality;
        int i = 0;
        while (i < copy_size) {
            face[j] = Unsafe.getLE32(attribute_item_data, offset);
            offset += 4;
            ++i;
            ++j;
        }
    }

    private void $initFields$() {
        try {
            this.attribute_quantization_transforms_ = new ArrayList();
            this.min_signed_values_ = new IntList();
            this.quantized_portable_attributes_ = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

