/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Algorithms;

public class IntList {
    private int count;
    int[] data;

    public int getCount() {
        return this.count;
    }

    public IntList() {
        this.data = new int[10];
    }

    public IntList(int size) {
        this.data = new int[size];
        this.count = size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public void setCapacity(int value) {
        if (value <= this.data.length) {
            return;
        }
        int[] newData = new int[value];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    public void add(int v) {
        this.ensureCapacity(this.count + 1);
        this.data[this.count++] = v;
    }

    public void addRange(int[] v) {
        this.addRange(v, v.length);
    }

    public void addRange(IntList v) {
        this.addRange(v.data, v.count);
    }

    public void addRange(int[] v, int length) {
        if (length > 0) {
            this.ensureCapacity(this.count + length);
            System.arraycopy(v, 0, this.data, this.count, length);
            this.count += length;
        }
    }

    public void clear() {
        this.count = 0;
    }

    public void removeAt(int idx) {
        if (idx == this.count - 1) {
            --this.count;
        } else {
            System.arraycopy(this.data, idx + 1, this.data, idx, this.count - idx - 1);
            --this.count;
        }
    }

    public int get(int idx) {
        return this.data[idx];
    }

    public void set(int idx, int value) {
        this.data[idx] = value;
    }

    public int getBack() {
        return this.data[this.count - 1];
    }

    public void popBack() {
        if (this.count > 0) {
            --this.count;
        }
    }

    public void reverse() {
        Algorithms.reverse(this.data, 0, this.count);
    }

    public void resize(int newSize) {
        this.ensureCapacity(newSize);
        this.count = newSize;
    }

    public void resize(int newSize, int newValue) {
        this.ensureCapacity(newSize);
        for (int i = this.count; i < newSize; ++i) {
            this.data[i] = newValue;
        }
        this.count = newSize;
    }

    private void ensureCapacity(int newSize) {
        int capacity;
        if (newSize < this.data.length) {
            return;
        }
        for (capacity = this.data.length; capacity < newSize; capacity += capacity >> 1) {
        }
        this.setCapacity(capacity);
    }

    public int[] toArray() {
        int[] ret = new int[this.count];
        System.arraycopy(this.data, 0, ret, 0, this.count);
        return ret;
    }
}

