/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Span;

@Internal
abstract class FloatSpan
extends Span {
    public static FloatSpan wrap(float[] array) {
        return new ArraySpan(array, 0, array.length);
    }

    public static FloatSpan wrap(float[] array, int offset, int length) {
        return new ArraySpan(array, offset, array.length);
    }

    public static FloatSpan wrap(byte[] array) {
        return new BytesSpan(array, 0, array.length / 4);
    }

    public static FloatSpan wrap(byte[] array, int offset, int length) {
        return new BytesSpan(array, offset / 4, length / 4);
    }

    protected FloatSpan(int offset, int length) {
        super(offset, length);
    }

    public abstract float get(int var1);

    public abstract void put(int var1, float var2);

    public abstract FloatSpan slice(int var1, int var2);

    public FloatSpan slice(int offset) {
        return this.slice(offset, this.length - offset);
    }

    public int compareTo(FloatSpan span) {
        int num = Math.min(this.size(), span.size());
        for (int i = 0; i < num; ++i) {
            int n = Float.compare(this.get(i), span.get(i));
            if (n == 0) continue;
            return n;
        }
        return Integer.compare(this.size(), span.size());
    }

    public boolean equals(FloatSpan span) {
        if (this.size() != span.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == span.get(i)) continue;
            return false;
        }
        return true;
    }

    public void copyTo(FloatSpan span) {
        for (int i = 0; i < this.size(); ++i) {
            span.put(i, this.get(i));
        }
    }

    public void fill(float v) {
        for (int i = 0; i < this.size(); ++i) {
            this.put(i, v);
        }
    }

    private static final class BytesSpan
    extends FloatSpan {
        private final byte[] array;

        public BytesSpan(byte[] array, int offset, int length) {
            super(offset, length);
            this.array = array;
        }

        @Override
        public float get(int idx) {
            this.rangeCheck(idx);
            int ptr = (idx + this.offset) * 4;
            int n = BytesSpan.getIntL(this.array, ptr);
            return Float.intBitsToFloat(n);
        }

        @Override
        public void put(int idx, float value) {
            this.rangeCheck(idx);
            int ptr = (idx + this.offset) * 4;
            BytesSpan.putIntL(this.array, ptr, Float.floatToRawIntBits(value));
        }

        @Override
        public FloatSpan slice(int offset, int size) {
            return new BytesSpan(this.array, offset + this.offset, size);
        }
    }

    private static final class ArraySpan
    extends FloatSpan {
        private final float[] array;

        public ArraySpan(float[] array, int offset, int length) {
            super(offset, length);
            this.array = array;
        }

        @Override
        public float get(int idx) {
            return this.array[idx + this.offset];
        }

        @Override
        public void put(int idx, float value) {
            this.rangeCheck(idx);
            this.array[idx + this.offset] = value;
        }

        @Override
        public FloatSpan slice(int offset, int size) {
            return new ArraySpan(this.array, offset + this.offset, size);
        }
    }
}

