/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DirectBitDecoder;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.FoldedBit32Decoder;
import dev.fileformat.drako.IBitDecoder;
import dev.fileformat.drako.PointAttributeVectorOutputIterator;
import dev.fileformat.drako.RAnsBitDecoder;
import java.util.Stack;

class DynamicIntegerPointsKdTreeDecoder {
    int bit_length_;
    int num_points_;
    int num_decoded_points_;
    int dimension_;
    IBitDecoder numbers_decoder_;
    DirectBitDecoder remaining_bits_decoder_;
    DirectBitDecoder axis_decoder_;
    DirectBitDecoder half_decoder_;
    int[] p_;
    int[] axes_;
    int[][] base_stack_;
    int[][] levels_stack_;
    private int compression_level_t;

    public DynamicIntegerPointsKdTreeDecoder(int compression_level, int dimension) {
        this.compression_level_t = compression_level;
        this.dimension_ = dimension;
        this.p_ = new int[dimension];
        this.axes_ = new int[dimension];
        this.base_stack_ = new int[32 * dimension + 1][];
        this.levels_stack_ = new int[32 * dimension + 1][];
        for (int i = 0; i < this.base_stack_.length; ++i) {
            this.base_stack_[i] = new int[dimension];
            this.levels_stack_[i] = new int[dimension];
        }
        switch (compression_level) {
            case 0: 
            case 1: {
                this.numbers_decoder_ = new DirectBitDecoder();
                break;
            }
            case 2: 
            case 3: {
                this.numbers_decoder_ = new RAnsBitDecoder();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.numbers_decoder_ = new FoldedBit32Decoder();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid compression level.");
            }
        }
        this.remaining_bits_decoder_ = new DirectBitDecoder();
        this.axis_decoder_ = new DirectBitDecoder();
        this.half_decoder_ = new DirectBitDecoder();
    }

    public void decodePoints(DecoderBuffer buffer, PointAttributeVectorOutputIterator oit) throws DrakoException {
        this.bit_length_ = buffer.decodeI32();
        if (this.bit_length_ > 32) {
            throw DracoUtils.failed();
        }
        this.num_points_ = buffer.decodeI32();
        if (this.num_points_ == 0) {
            return;
        }
        this.num_decoded_points_ = 0;
        this.numbers_decoder_.startDecoding(buffer);
        this.remaining_bits_decoder_.startDecoding(buffer);
        this.axis_decoder_.startDecoding(buffer);
        this.half_decoder_.startDecoding(buffer);
        this.decodeInternal(this.num_points_, oit);
        this.numbers_decoder_.endDecoding();
        this.remaining_bits_decoder_.endDecoding();
        this.axis_decoder_.endDecoding();
        this.half_decoder_.endDecoding();
    }

    int getAxis(int num_remaining_points, int[] levels, int last_axis) {
        boolean select_axis;
        boolean bl = select_axis = this.compression_level_t == 6;
        if (!select_axis) {
            return DracoUtils.incrementMod(last_axis, this.dimension_);
        }
        int best_axis = 0;
        if (num_remaining_points < 64) {
            for (int axis = 1; axis < this.dimension_; ++axis) {
                if (levels[best_axis] <= levels[axis]) continue;
                best_axis = axis;
            }
        } else {
            best_axis = this.axis_decoder_.decodeLeastSignificantBits32(4);
        }
        return best_axis;
    }

    void decodeInternal(int num_points, PointAttributeVectorOutputIterator oit) throws DrakoException {
        this.base_stack_[0] = new int[this.dimension_];
        this.levels_stack_[0] = new int[this.dimension_];
        Status init_status = new Status(num_points, 0, 0);
        Stack<Status> status_stack = new Stack<Status>();
        status_stack.push(init_status);
        while (!status_stack.isEmpty()) {
            int num_remaining_bits;
            Status status = (Status)status_stack.peek();
            status_stack.pop();
            int num_remaining_points = status.num_remaining_points;
            int last_axis = status.last_axis;
            int stack_pos = status.stack_pos;
            int[] old_base = this.base_stack_[stack_pos];
            int[] levels = this.levels_stack_[stack_pos];
            if (num_remaining_points > num_points) {
                throw DracoUtils.failed();
            }
            int axis = this.getAxis(num_remaining_points, levels, last_axis);
            if (axis >= this.dimension_) {
                throw DracoUtils.failed();
            }
            int level = levels[axis];
            if (this.bit_length_ - level == 0) {
                for (int i = 0; i < num_remaining_points; ++i) {
                    oit.set(old_base);
                    oit.next();
                    ++this.num_decoded_points_;
                }
                continue;
            }
            if (num_remaining_points <= 2) {
                int i;
                this.axes_[0] = axis;
                for (i = 1; i < this.dimension_; ++i) {
                    this.axes_[i] = DracoUtils.incrementMod(this.axes_[i - 1], this.dimension_);
                }
                for (i = 0; i < num_remaining_points; ++i) {
                    for (int j = 0; j < this.dimension_; ++j) {
                        this.p_[this.axes_[j]] = 0;
                        num_remaining_bits = this.bit_length_ - levels[this.axes_[j]];
                        if (num_remaining_bits != 0) {
                            this.p_[this.axes_[j]] = this.remaining_bits_decoder_.decodeLeastSignificantBits32(num_remaining_bits);
                        }
                        this.p_[this.axes_[j]] = old_base[this.axes_[j]] | this.p_[this.axes_[j]];
                    }
                    oit.set(this.p_);
                    oit.next();
                    ++this.num_decoded_points_;
                }
                continue;
            }
            if (this.num_decoded_points_ > this.num_points_) {
                throw DracoUtils.failed();
            }
            num_remaining_bits = this.bit_length_ - level;
            int modifier = 1 << num_remaining_bits - 1;
            System.arraycopy(old_base, 0, this.base_stack_[stack_pos + 1], 0, this.dimension_);
            int[] nArray = this.base_stack_[stack_pos + 1];
            int n = axis;
            nArray[n] = nArray[n] + modifier;
            int incoming_bits = DracoUtils.mostSignificantBit(num_remaining_points);
            int number = this.decodeNumber(incoming_bits);
            int first_half = num_remaining_points / 2 - number;
            int second_half = num_remaining_points - first_half;
            if (first_half != second_half && !this.half_decoder_.decodeNextBit()) {
                int t = first_half;
                first_half = second_half;
                second_half = t;
            }
            int[] nArray2 = this.levels_stack_[stack_pos];
            int n2 = axis;
            nArray2[n2] = nArray2[n2] + 1;
            System.arraycopy(this.levels_stack_[stack_pos], 0, this.levels_stack_[stack_pos + 1], 0, this.dimension_);
            if (first_half != 0) {
                status_stack.push(new Status(first_half, axis, stack_pos));
            }
            if (second_half == 0) continue;
            status_stack.push(new Status(second_half, axis, stack_pos + 1));
        }
    }

    private int decodeNumber(int nbits) {
        return this.numbers_decoder_.decodeLeastSignificantBits32(nbits);
    }

    static class Status {
        public int num_remaining_points;
        public int last_axis;
        public int stack_pos;

        public Status(int num_remaining_points_, int last_axis_, int stack_pos_) {
            this.num_remaining_points = num_remaining_points_;
            this.last_axis = last_axis_;
            this.stack_pos = stack_pos_;
        }
    }
}

