/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AsposeUtils;
import dev.fileformat.drako.GeometryAttribute;
import dev.fileformat.drako.GeometryMetadata;
import dev.fileformat.drako.IntList;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.Struct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DracoPointCloud {
    private ArrayList<PointAttribute> attributes;
    private ArrayList<GeometryMetadata> metadatas;
    private IntList[] namedAttributeIndex;
    private int numPoints;

    public int numNamedAttributes(int type) {
        int idx = type;
        if (idx < 0 || idx >= this.namedAttributeIndex.length) {
            return 0;
        }
        return this.namedAttributeIndex[idx].getCount();
    }

    public int getNamedAttributeId(int type) {
        return this.getNamedAttributeId(type, 0);
    }

    public int getNamedAttributeId(int type, int i) {
        int idx = type;
        if (idx < 0 || idx >= this.namedAttributeIndex.length) {
            return -1;
        }
        IntList attrs = this.namedAttributeIndex[idx];
        if (attrs == null) {
            return -1;
        }
        if (i < 0 || i >= attrs.getCount()) {
            return -1;
        }
        return attrs.get(i);
    }

    public PointAttribute getNamedAttribute(int type, int i) {
        int id = this.getNamedAttributeId(type, i);
        if (id == -1) {
            return null;
        }
        return this.attributes.get(id);
    }

    public PointAttribute getNamedAttribute(int type) {
        return this.getNamedAttribute(type, 0);
    }

    public PointAttribute getNamedAttributeByCustomId(int type, short customId) {
        int idx = type;
        for (int attId = 0; attId < this.namedAttributeIndex[idx].getCount(); ++attId) {
            if (this.attributes.get(this.namedAttributeIndex[idx].get(attId)).getUniqueId() != customId) continue;
            return this.attributes.get(this.namedAttributeIndex[idx].get(attId));
        }
        return null;
    }

    public int getNumAttributes() {
        return this.attributes.size();
    }

    public PointAttribute attribute(int attId) {
        return this.attributes.get(attId);
    }

    public int addAttribute(PointAttribute pa) {
        this.attributes.add(pa);
        IntList attrs = this.namedAttributeIndex[pa.getAttributeType()];
        if (attrs == null) {
            IntList tmp0;
            this.namedAttributeIndex[pa.getAttributeType()] = tmp0 = new IntList();
            attrs = tmp0;
        }
        int ret = this.attributes.size() - 1;
        attrs.add(ret);
        pa.setUniqueId((short)ret);
        return ret;
    }

    public int addAttribute(GeometryAttribute att, boolean identityMapping, int numAttributeValues) {
        int type = att.getAttributeType();
        if (type == -1) {
            return -1;
        }
        int attId = this.addAttribute((PointAttribute)att);
        PointAttribute pa = this.attribute(attId);
        pa.setIdentityMapping(identityMapping);
        if (!identityMapping) {
            pa.setExplicitMapping(this.numPoints);
        } else {
            pa.resize(this.numPoints);
        }
        if (numAttributeValues > 0) {
            pa.reset(numAttributeValues);
        }
        return attId;
    }

    public void deduplicateAttributeValues() {
        if (this.numPoints == 0) {
            return;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            PointAttribute attr = this.attributes.get(i);
            attr.deduplicateValues();
        }
    }

    public void deduplicatePointIds() {
        HashMap<VertexIndex, Integer> uniquePointMap = new HashMap<VertexIndex, Integer>();
        int numUniquePoints = 0;
        int[] indexMap = new int[this.numPoints];
        IntList uniquePoints = new IntList();
        Integer[] ref1 = new Integer[1];
        for (int i = 0; i < this.numPoints; ++i) {
            int tmp;
            VertexIndex p = new VertexIndex(this, i);
            if (AsposeUtils.tryGetValue(uniquePointMap, p, ref1)) {
                indexMap[i] = tmp = ref1[0] == null ? 0 : ref1[0];
                continue;
            }
            tmp = ref1[0] == null ? 0 : ref1[0];
            uniquePointMap.put(Struct.byVal(p), numUniquePoints);
            indexMap[i] = numUniquePoints++;
            uniquePoints.add(i);
        }
        if (numUniquePoints == this.numPoints) {
            return;
        }
        this.applyPointIdDeduplication(indexMap, uniquePoints);
        this.setNumPoints(numUniquePoints);
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public void setNumPoints(int value) {
        this.numPoints = value;
    }

    ArrayList<GeometryMetadata> getMetadatas() {
        return this.metadatas;
    }

    void applyPointIdDeduplication(int[] idMap, IntList uniquePointIds) {
        int numUniquePoints = 0;
        for (int i = 0; i < uniquePointIds.getCount(); ++i) {
            int newPointId = idMap[uniquePointIds.get(i)];
            if (newPointId < numUniquePoints) continue;
            for (int a = 0; a < this.attributes.size(); ++a) {
                PointAttribute attr = this.attributes.get(a);
                attr.setPointMapEntry(newPointId, attr.mappedIndex(uniquePointIds.get(i)));
            }
            numUniquePoints = newPointId + 1;
        }
        for (int a = 0; a < this.attributes.size(); ++a) {
            this.attributes.get(a).setExplicitMapping(numUniquePoints);
        }
    }

    PointAttribute getAttributeByUniqueId(int uniqueId) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            PointAttribute attr = this.attributes.get(i);
            if (attr.getUniqueId() != uniqueId) continue;
            return attr;
        }
        return null;
    }

    public DracoPointCloud() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.attributes = new ArrayList();
            this.metadatas = new ArrayList();
            this.namedAttributeIndex = new IntList[5];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final class VertexIndex
    implements Comparable<VertexIndex>,
    Struct<VertexIndex>,
    Serializable {
        private DracoPointCloud cloud;
        private int p;
        static final long serialVersionUID = -41225692L;

        public VertexIndex(DracoPointCloud cloud, int p) {
            this.cloud = cloud;
            this.p = p;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VertexIndex)) {
                return false;
            }
            int ret = this.compareTo((VertexIndex)obj);
            return ret == 0;
        }

        @Override
        public int compareTo(VertexIndex other) {
            for (int i = 0; i < this.cloud.attributes.size(); ++i) {
                int id1;
                PointAttribute attr = (PointAttribute)this.cloud.attributes.get(i);
                int id0 = attr.mappedIndex(this.p);
                if (id0 < (id1 = attr.mappedIndex(other.p))) {
                    return -1;
                }
                if (id0 <= id1) continue;
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("p: ", new Object[0]));
            for (int i = 0; i < this.cloud.attributes.size(); ++i) {
                PointAttribute attr = (PointAttribute)this.cloud.attributes.get(i);
                int id0 = attr.mappedIndex(this.p);
                if (i > 0) {
                    sb.append("/");
                }
                sb.append(id0);
            }
            return sb.toString();
        }

        public VertexIndex() {
        }

        private VertexIndex(VertexIndex other) {
            this.cloud = other.cloud;
            this.p = other.p;
        }

        @Override
        public VertexIndex clone() {
            return new VertexIndex(this);
        }

        @Override
        public void copyFrom(VertexIndex src) {
            if (src == null) {
                return;
            }
            this.cloud = src.cloud;
            this.p = src.p;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.cloud.attributes.size(); ++i) {
                int attId = ((PointAttribute)this.cloud.attributes.get(i)).mappedIndex(this.p);
                hash = attId << 2 ^ hash << 1;
            }
            return hash;
        }
    }
}

