/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.MetaClass;
import dev.fileformat.drako.Pure;
import java.nio.ByteBuffer;

@Internal
class BitUtils {
    public static final int SHORT_BYTES = 2;
    public static final int INTEGER_BYTES = 4;
    public static final int LONG_BYTES = 8;
    public static final int DOUBLE_BYTES = 8;
    public static final int FLOAT_BYTES = 4;

    BitUtils() {
    }

    public static int getInt32(byte[] array, int offset) {
        return (array[offset + 3] & 0xFF) << 24 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    public static long getInt64(byte[] array, int offset) {
        long result = 0L;
        int i = 0;
        int p = offset + 7;
        while (i < 8) {
            result <<= 8;
            result |= (long)(array[p] & 0xFF);
            ++i;
            --p;
        }
        return result;
    }

    public static long getInt64(byte[] array) {
        return BitUtils.getInt64(array, 0);
    }

    public static short getInt16(byte[] array, int offset) {
        return (short)((array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF);
    }

    public static double getDouble(byte[] array, int offset) {
        long n = BitUtils.getInt64(array, offset);
        return Double.longBitsToDouble(n);
    }

    public static float getFloat(byte[] array, int offset) {
        int n = BitUtils.getInt32(array, offset);
        return Float.intBitsToFloat(n);
    }

    public static int hashCode(boolean value) {
        return value ? 1 : 0;
    }

    public static int hashCode(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public static int sizeof(MetaClass<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return BitUtils.sizeof(type.classOf());
    }

    public static int sizeof(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (type == Byte.TYPE || type == Boolean.TYPE) {
            return 1;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4;
        }
        if (type == Double.TYPE || type == Long.TYPE) {
            return 8;
        }
        throw new IllegalArgumentException("Cannot get size of non-primitive type");
    }

    public static byte[] toBytes(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot convert null to bytes");
        }
        Class<?> type = val.getClass();
        if (type == Integer.class) {
            return BitUtils.toBytes(((Number)val).intValue());
        }
        if (type == Short.class) {
            return BitUtils.toBytes(((Number)val).shortValue());
        }
        if (type == Long.class) {
            return BitUtils.toBytes(((Number)val).longValue());
        }
        if (type == Byte.class) {
            return BitUtils.toBytes(((Number)val).byteValue());
        }
        if (type == Float.class) {
            return BitUtils.toBytes(((Number)val).floatValue());
        }
        if (type == Double.class) {
            return BitUtils.toBytes(((Number)val).doubleValue());
        }
        if (type == int[].class) {
            return BitUtils.toBytes((int[])val);
        }
        if (type == short[].class) {
            return BitUtils.toBytes((short[])val);
        }
        if (type == long[].class) {
            return BitUtils.toBytes((long[])val);
        }
        if (type == byte[].class) {
            return (byte[])val;
        }
        if (type == float[].class) {
            return BitUtils.toBytes((float[])val);
        }
        if (type == double[].class) {
            return BitUtils.toBytes((double[])val);
        }
        throw new IllegalArgumentException("Cannot convert unsupported type to bytes");
    }

    public static byte[] toBytes(byte val) {
        return new byte[]{val};
    }

    public static byte[] toBytes(short val) {
        byte[] ret = new byte[2];
        BitUtils.toBytes(ret, 0, val);
        return ret;
    }

    public static byte[] toBytes(int val) {
        byte[] ret = new byte[4];
        BitUtils.toBytes(ret, 0, val);
        return ret;
    }

    public static byte[] toBytes(long val) {
        byte[] ret = new byte[8];
        BitUtils.toBytes(ret, 0, val);
        return ret;
    }

    public static byte[] toBytes(float val) {
        byte[] ret = new byte[4];
        BitUtils.toBytes(ret, 0, val);
        return ret;
    }

    public static byte[] toBytes(double val) {
        byte[] ret = new byte[8];
        BitUtils.toBytes(ret, 0, val);
        return ret;
    }

    public static byte[] toBytes(boolean[] vals) {
        boolean size = true;
        byte[] ret = new byte[vals.length * 1];
        int i = 0;
        int p = 0;
        while (i < vals.length) {
            ret[p] = (byte)(vals[i] ? 1 : 0);
            ++i;
            ++p;
        }
        return ret;
    }

    public static byte[] toBytes(short[] vals) {
        int size = 2;
        byte[] ret = new byte[vals.length * 2];
        int i = 0;
        int p = 0;
        while (i < vals.length) {
            BitUtils.toBytes(ret, p, vals[i]);
            ++i;
            p += 2;
        }
        return ret;
    }

    public static byte[] toBytes(int[] vals) {
        int size = 4;
        byte[] ret = new byte[vals.length * 4];
        int i = 0;
        int p = 0;
        while (i < vals.length) {
            BitUtils.toBytes(ret, p, vals[i]);
            ++i;
            p += 4;
        }
        return ret;
    }

    public static byte[] toBytes(long[] vals) {
        int size = 8;
        byte[] ret = new byte[vals.length * 8];
        int i = 0;
        int p = 0;
        while (i < vals.length) {
            BitUtils.toBytes(ret, p, vals[i]);
            ++i;
            p += 8;
        }
        return ret;
    }

    public static byte[] toBytes(float[] vals) {
        int size = 4;
        byte[] ret = new byte[vals.length * 4];
        int i = 0;
        int p = 0;
        while (i < vals.length) {
            BitUtils.toBytes(ret, p, vals[i]);
            ++i;
            p += 4;
        }
        return ret;
    }

    public static byte[] toBytes(double[] vals) {
        int size = 8;
        byte[] ret = new byte[vals.length * 8];
        int i = 0;
        int p = 0;
        while (i < vals.length) {
            BitUtils.toBytes(ret, p, vals[i]);
            ++i;
            p += 8;
        }
        return ret;
    }

    public static byte[] toBytes(@Pure ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static void toBytes(byte[] array, int offset, short[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 2;
        }
    }

    public static void toBytes(byte[] array, int offset, short val) {
        array[offset + 0] = (byte)(val & 0xFF);
        array[offset + 1] = (byte)(val >> 8 & 0xFF);
    }

    public static void toBytes(byte[] array, int offset, Integer[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 4;
        }
    }

    public static void toBytes(byte[] array, int offset, int[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 4;
        }
    }

    public static void toBytes(byte[] array, int offset, int val) {
        array[offset + 0] = (byte)(val & 0xFF);
        array[offset + 1] = (byte)(val >> 8 & 0xFF);
        array[offset + 2] = (byte)(val >> 16 & 0xFF);
        array[offset + 3] = (byte)(val >> 24 & 0xFF);
    }

    public static void toBytes(byte[] array, int offset, long[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 8;
        }
    }

    public static void toBytes(byte[] array, int offset, long val) {
        array[offset + 0] = (byte)(val & 0xFFL);
        array[offset + 1] = (byte)(val >> 8 & 0xFFL);
        array[offset + 2] = (byte)(val >> 16 & 0xFFL);
        array[offset + 3] = (byte)(val >> 24 & 0xFFL);
        array[offset + 4] = (byte)(val >> 32 & 0xFFL);
        array[offset + 5] = (byte)(val >> 40 & 0xFFL);
        array[offset + 6] = (byte)(val >> 48 & 0xFFL);
        array[offset + 7] = (byte)(val >> 56 & 0xFFL);
    }

    public static void toBytes(byte[] array, int offset, float[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 4;
        }
    }

    public static void toBytes(byte[] array, int offset, float f) {
        int val = Float.floatToRawIntBits(f);
        array[offset + 0] = (byte)(val & 0xFF);
        array[offset + 1] = (byte)(val >> 8 & 0xFF);
        array[offset + 2] = (byte)(val >> 16 & 0xFF);
        array[offset + 3] = (byte)(val >> 24 & 0xFF);
    }

    public static void toBytes(byte[] array, int offset, Double[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 8;
        }
    }

    public static void toBytes(byte[] array, int offset, double[] val, int off, int len) {
        int p = offset;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            BitUtils.toBytes(array, p, val[i]);
            p += 8;
        }
    }

    public static void toBytes(byte[] array, int offset, double d) {
        long val = Double.doubleToRawLongBits(d);
        array[offset + 0] = (byte)(val & 0xFFL);
        array[offset + 1] = (byte)(val >> 8 & 0xFFL);
        array[offset + 2] = (byte)(val >> 16 & 0xFFL);
        array[offset + 3] = (byte)(val >> 24 & 0xFFL);
        array[offset + 4] = (byte)(val >> 32 & 0xFFL);
        array[offset + 5] = (byte)(val >> 40 & 0xFFL);
        array[offset + 6] = (byte)(val >> 48 & 0xFFL);
        array[offset + 7] = (byte)(val >> 56 & 0xFFL);
    }

    public static void fromBytes(byte[] bytes, int offset, double[] val, int off, int len) {
        int s = offset;
        int d = off;
        for (int i = 0; i < len; ++i) {
            val[d] = BitUtils.getDouble(bytes, s);
            ++d;
            s += 8;
        }
    }

    public static void fromBytes(byte[] bytes, int offset, float[] val, int off, int len) {
        int s = offset;
        int d = off;
        for (int i = 0; i < len; ++i) {
            val[d] = BitUtils.getFloat(bytes, s);
            ++d;
            s += 4;
        }
    }

    public static void fromBytes(byte[] bytes, int offset, int[] val, int off, int len) {
        int s = offset;
        int d = off;
        for (int i = 0; i < len; ++i) {
            val[d] = BitUtils.getInt32(bytes, s);
            ++d;
            s += 4;
        }
    }

    public static void fromBytes(byte[] bytes, int offset, long[] val, int off, int len) {
        int s = offset;
        int d = off;
        for (int i = 0; i < len; ++i) {
            val[d] = BitUtils.getInt64(bytes, s);
            ++d;
            s += 8;
        }
    }

    public static int compareUnsigned(int x, int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static int compareUnsigned(byte x, byte y) {
        return Integer.compare(0xFF & x, 0xFF & y);
    }

    public static int compareUnsigned(short x, short y) {
        return Integer.compare(0xFFFF & x, 0xFFFF & y);
    }

    public static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }
}

