/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox.multipart;

import android.text.TextUtils;
import java.util.Random;
import org.apache.http.util.EncodingUtils;

class Boundary {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final String boundary;
    private final byte[] startingBoundary;
    private final byte[] closingBoundary;

    Boundary(String boundary) {
        if (TextUtils.isEmpty((CharSequence)boundary)) {
            boundary = Boundary.generateBoundary();
        }
        this.boundary = boundary;
        String starting = "--" + boundary + "\r\n";
        String closing = "--" + boundary + "--" + "\r\n";
        this.startingBoundary = EncodingUtils.getAsciiBytes((String)starting);
        this.closingBoundary = EncodingUtils.getAsciiBytes((String)closing);
    }

    String getBoundary() {
        return this.boundary;
    }

    byte[] getStartingBoundary() {
        return this.startingBoundary;
    }

    byte[] getClosingBoundary() {
        return this.closingBoundary;
    }

    private static String generateBoundary() {
        Random rand = new Random();
        int count = rand.nextInt(11) + 30;
        StringBuilder buffer = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            buffer.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        return buffer.toString();
    }
}

