/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache.plus;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyLog;
import com.android.volley.error.ParseError;
import com.android.volley.misc.ImageUtils;
import com.android.volley.misc.Utils;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.ui.RecyclingBitmapDrawable;
import java.io.File;
import java.io.FileNotFoundException;

public class ImageRequest
extends Request<BitmapDrawable> {
    private static final int IMAGE_TIMEOUT_MS = 1000;
    private static final int IMAGE_MAX_RETRIES = 2;
    private static final float IMAGE_BACKOFF_MULT = 2.0f;
    private static final boolean PREFER_QUALITY_OVER_SPEED = false;
    private final Response.Listener<BitmapDrawable> mListener;
    private final Bitmap.Config mDecodeConfig;
    private final int mMaxWidth;
    private final int mMaxHeight;
    private Resources mResources;
    private ContentResolver mContentResolver;
    private static final Object sDecodeLock = new Object();
    private final BitmapFactory.Options defaultOptions;

    public ImageRequest(String url, Resources resources, ContentResolver contentResolver, Response.Listener<BitmapDrawable> listener, int maxWidth, int maxHeight, Bitmap.Config decodeConfig, Response.ErrorListener errorListener) {
        super(0, url, errorListener);
        this.setRetryPolicy(new DefaultRetryPolicy(1000, 2, 2.0f));
        this.mResources = resources;
        this.mContentResolver = contentResolver;
        this.mListener = listener;
        this.mDecodeConfig = decodeConfig;
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
        this.defaultOptions = ImageRequest.getDefaultOptions();
    }

    @Override
    public Request.Priority getPriority() {
        return Request.Priority.LOW;
    }

    private static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        int resized = maxPrimary;
        double ratio = (double)actualSecondary / (double)actualPrimary;
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response<BitmapDrawable> parseNetworkResponse(NetworkResponse response) {
        Object object = sDecodeLock;
        synchronized (object) {
            try {
                if (this.getUrl().startsWith("video")) {
                    return this.doVideoFileParse();
                }
                if (this.getUrl().startsWith("file")) {
                    return this.doFileParse();
                }
                if (this.getUrl().startsWith("android.resource")) {
                    return this.doResourceParse();
                }
                if (this.getUrl().startsWith("content")) {
                    return this.doContentParse();
                }
                return this.doParse(response);
            }
            catch (OutOfMemoryError e) {
                VolleyLog.e("Caught OOM for %d byte image, url=%s", response.data.length, this.getUrl());
                return Response.error(new ParseError(e));
            }
        }
    }

    private Response<BitmapDrawable> doVideoFileParse() {
        String requestUrl = this.getUrl();
        File bitmapFile = new File(requestUrl.substring(8, requestUrl.length()));
        if (!bitmapFile.exists() || !bitmapFile.isFile()) {
            return Response.error(new ParseError(new FileNotFoundException(String.format("File not found: %s", bitmapFile.getAbsolutePath()))));
        }
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inInputShareable = true;
        decodeOptions.inPurgeable = true;
        decodeOptions.inPreferredConfig = this.mDecodeConfig;
        Bitmap bitmap = null;
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            bitmap = this.getVideoFrame(bitmapFile.getAbsolutePath());
            this.addMarker("read-full-size-image-from-file");
        } else {
            decodeOptions.inJustDecodeBounds = true;
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = ImageUtils.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = this.getVideoFrame(bitmapFile.getAbsolutePath());
            this.addMarker(String.format("read-from-file-scaled-times-%d", decodeOptions.inSampleSize));
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
                this.addMarker("scaling-read-from-file-bitmap");
            } else {
                bitmap = tempBitmap;
            }
        }
        if (bitmap == null) {
            return Response.error(new ParseError());
        }
        Object drawable = Utils.hasHoneycomb() ? new BitmapDrawable(this.mResources, bitmap) : new RecyclingBitmapDrawable(this.mResources, bitmap);
        return Response.success(drawable, HttpHeaderParser.parseBitmapCacheHeaders(bitmap));
    }

    private Bitmap getVideoFrame(String path) {
        return ThumbnailUtils.createVideoThumbnail((String)path, (int)1);
    }

    private Response<BitmapDrawable> doFileParse() {
        String requestUrl = this.getUrl();
        File bitmapFile = new File(requestUrl.substring(7, requestUrl.length()));
        if (!bitmapFile.exists() || !bitmapFile.isFile()) {
            return Response.error(new ParseError(new FileNotFoundException(String.format("File not found: %s", bitmapFile.getAbsolutePath()))));
        }
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inInputShareable = true;
        decodeOptions.inPurgeable = true;
        decodeOptions.inPreferredConfig = this.mDecodeConfig;
        Bitmap bitmap = null;
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            bitmap = BitmapFactory.decodeFile((String)bitmapFile.getAbsolutePath(), (BitmapFactory.Options)decodeOptions);
            this.addMarker("read-full-size-image-from-file");
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)bitmapFile.getAbsolutePath(), (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = ImageUtils.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeFile((String)bitmapFile.getAbsolutePath(), (BitmapFactory.Options)decodeOptions);
            this.addMarker(String.format("read-from-file-scaled-times-%d", decodeOptions.inSampleSize));
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
                this.addMarker("scaling-read-from-file-bitmap");
            } else {
                bitmap = tempBitmap;
            }
        }
        if (bitmap == null) {
            return Response.error(new ParseError());
        }
        Object drawable = Utils.hasHoneycomb() ? new BitmapDrawable(this.mResources, bitmap) : new RecyclingBitmapDrawable(this.mResources, bitmap);
        return Response.success(drawable, HttpHeaderParser.parseBitmapCacheHeaders(bitmap));
    }

    private Response<BitmapDrawable> doContentParse() {
        if (this.mContentResolver == null) {
            return Response.error(new ParseError("Content Resolver instance is null"));
        }
        String requestUrl = this.getUrl();
        Uri imageUri = Uri.parse((String)requestUrl);
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inInputShareable = true;
        decodeOptions.inPurgeable = true;
        decodeOptions.inPreferredConfig = this.mDecodeConfig;
        Bitmap bitmap = null;
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            bitmap = ImageUtils.decodeStream(this.mContentResolver, imageUri, decodeOptions);
            this.addMarker("read-full-size-image-from-resource");
        } else {
            decodeOptions.inJustDecodeBounds = true;
            ImageUtils.decodeStream(this.mContentResolver, imageUri, decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = ImageUtils.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = ImageUtils.decodeStream(this.mContentResolver, imageUri, decodeOptions);
            this.addMarker(String.format("read-from-resource-scaled-times-%d", decodeOptions.inSampleSize));
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
                this.addMarker("scaling-read-from-resource-bitmap");
            } else {
                bitmap = tempBitmap;
            }
        }
        if (bitmap == null) {
            return Response.error(new ParseError());
        }
        Object drawable = Utils.hasHoneycomb() ? new BitmapDrawable(this.mResources, bitmap) : new RecyclingBitmapDrawable(this.mResources, bitmap);
        return Response.success(drawable, HttpHeaderParser.parseBitmapCacheHeaders(bitmap));
    }

    private Response<BitmapDrawable> doResourceParse() {
        if (this.mResources == null) {
            return Response.error(new ParseError());
        }
        String requestUrl = this.getUrl();
        int resourceId = Integer.valueOf(Uri.parse((String)requestUrl).getLastPathSegment());
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inInputShareable = true;
        decodeOptions.inPurgeable = true;
        decodeOptions.inPreferredConfig = this.mDecodeConfig;
        Bitmap bitmap = null;
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            bitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)resourceId, (BitmapFactory.Options)decodeOptions);
            this.addMarker("read-full-size-image-from-resource");
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)this.mResources, (int)resourceId, (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth);
            decodeOptions.inJustDecodeBounds = false;
            decodeOptions.inSampleSize = ImageUtils.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeResource((Resources)this.mResources, (int)resourceId, (BitmapFactory.Options)decodeOptions);
            this.addMarker(String.format("read-from-resource-scaled-times-%d", decodeOptions.inSampleSize));
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
                this.addMarker("scaling-read-from-resource-bitmap");
            } else {
                bitmap = tempBitmap;
            }
        }
        if (bitmap == null) {
            return Response.error(new ParseError());
        }
        Object drawable = Utils.hasHoneycomb() ? new BitmapDrawable(this.mResources, bitmap) : new RecyclingBitmapDrawable(this.mResources, bitmap);
        return Response.success(drawable, HttpHeaderParser.parseBitmapCacheHeaders(bitmap));
    }

    @TargetApi(value=10)
    private Response<BitmapDrawable> doParse(NetworkResponse response) {
        byte[] data = response.data;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        decodeOptions.inInputShareable = true;
        decodeOptions.inPurgeable = true;
        decodeOptions.inPreferredConfig = this.mDecodeConfig;
        Bitmap bitmap = null;
        if (this.mMaxWidth == 0 && this.mMaxHeight == 0) {
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
        } else {
            decodeOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
            int actualWidth = decodeOptions.outWidth;
            int actualHeight = decodeOptions.outHeight;
            int desiredWidth = ImageRequest.getResizedDimension(this.mMaxWidth, this.mMaxHeight, actualWidth, actualHeight);
            int desiredHeight = ImageRequest.getResizedDimension(this.mMaxHeight, this.mMaxWidth, actualHeight, actualWidth);
            decodeOptions.inJustDecodeBounds = false;
            if (Utils.hasGingerbreadMR1()) {
                decodeOptions.inPreferQualityOverSpeed = false;
            }
            decodeOptions.inSampleSize = ImageUtils.findBestSampleSize(actualWidth, actualHeight, desiredWidth, desiredHeight);
            Bitmap tempBitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)decodeOptions);
            if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
                tempBitmap.recycle();
            } else {
                bitmap = tempBitmap;
            }
        }
        if (bitmap == null) {
            return Response.error(new ParseError(response));
        }
        Object drawable = Utils.hasHoneycomb() ? new BitmapDrawable(this.mResources, bitmap) : new RecyclingBitmapDrawable(this.mResources, bitmap);
        return Response.success(drawable, HttpHeaderParser.parseCacheHeaders(response));
    }

    @Override
    protected void deliverResponse(BitmapDrawable response) {
        this.mListener.onResponse(response);
    }

    @TargetApi(value=11)
    public static BitmapFactory.Options getDefaultOptions() {
        BitmapFactory.Options decodeBitmapOptions = new BitmapFactory.Options();
        decodeBitmapOptions.inDither = false;
        decodeBitmapOptions.inScaled = false;
        decodeBitmapOptions.inPreferredConfig = Bitmap.Config.RGB_565;
        decodeBitmapOptions.inSampleSize = 1;
        if (Utils.hasHoneycomb()) {
            decodeBitmapOptions.inMutable = true;
        }
        return decodeBitmapOptions;
    }

    private BitmapFactory.Options getOptions() {
        BitmapFactory.Options result = new BitmapFactory.Options();
        ImageRequest.copyOptions(this.defaultOptions, result);
        return result;
    }

    private static void copyOptions(BitmapFactory.Options from, BitmapFactory.Options to) {
        if (Build.VERSION.SDK_INT >= 11) {
            ImageRequest.copyOptionsHoneycomb(from, to);
        } else if (Build.VERSION.SDK_INT >= 10) {
            ImageRequest.copyOptionsGingerbreadMr1(from, to);
        } else {
            ImageRequest.copyOptionsFroyo(from, to);
        }
    }

    @TargetApi(value=11)
    private static void copyOptionsHoneycomb(BitmapFactory.Options from, BitmapFactory.Options to) {
        ImageRequest.copyOptionsGingerbreadMr1(from, to);
        to.inMutable = from.inMutable;
    }

    @TargetApi(value=10)
    private static void copyOptionsGingerbreadMr1(BitmapFactory.Options from, BitmapFactory.Options to) {
        ImageRequest.copyOptionsFroyo(from, to);
        to.inPreferQualityOverSpeed = from.inPreferQualityOverSpeed;
    }

    private static void copyOptionsFroyo(BitmapFactory.Options from, BitmapFactory.Options to) {
        to.inDensity = from.inDensity;
        to.inDither = from.inDither;
        to.inInputShareable = from.inInputShareable;
        to.inPreferredConfig = from.inPreferredConfig;
        to.inPurgeable = from.inPurgeable;
        to.inSampleSize = from.inSampleSize;
        to.inScaled = from.inScaled;
        to.inScreenDensity = from.inScreenDensity;
        to.inTargetDensity = from.inTargetDensity;
    }
}

