/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import com.android.volley.NetworkResponse;
import com.android.volley.RequestTickle;
import com.android.volley.error.VolleyError;
import com.android.volley.request.GsonRequest;
import com.android.volley.toolbox.VolleyTickle;
import com.google.gson.Gson;

public class AsyncRequestLoader<T>
extends AsyncTaskLoader<T> {
    private GsonRequest<T> request;
    private VolleyError error;
    private T data;

    public AsyncRequestLoader(Context context, GsonRequest<T> request) {
        super(context);
        this.request = request;
    }

    public T loadInBackground() {
        RequestTickle requestTickle = VolleyTickle.newRequestTickle(this.getContext());
        requestTickle.add(this.request);
        NetworkResponse networkResponse = requestTickle.start();
        if (networkResponse.statusCode >= 200 && networkResponse.statusCode < 300) {
            this.data = new Gson().fromJson(VolleyTickle.parseResponse(networkResponse), this.request.getClazz());
        }
        this.error = new VolleyError(networkResponse);
        return this.data;
    }

    protected void onStartLoading() {
        super.onStartLoading();
        if (this.data != null) {
            this.deliverResult(this.data);
        }
        if (this.data == null || this.takeContentChanged()) {
            this.forceLoad();
        }
    }

    public void deliverResult(T data) {
        if (this.isReset() && data != null) {
            this.releaseResources(data);
            return;
        }
        T oldData = this.data;
        this.data = data;
        if (this.isStarted()) {
            super.deliverResult(data);
        }
        if (oldData != null && oldData != data) {
            this.releaseResources(oldData);
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    protected void onReset() {
        this.onStopLoading();
        if (this.data != null) {
            this.releaseResources(this.data);
            this.data = null;
        }
    }

    public void onCanceled(T data) {
        super.onCanceled(data);
        this.releaseResources(data);
        this.request.cancel();
    }

    private void releaseResources(T data) {
    }

    public VolleyError getError() {
        return this.error;
    }
}

