/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.ClojureExtension;
import dev.clojurephant.plugin.clojurescript.ClojureScriptExtension;
import dev.clojurephant.plugin.common.ClojurephantModel;
import dev.clojurephant.plugin.common.internal.Edn;
import java.util.HashMap;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class ClojurephantModelBuilder
implements ToolingModelBuilder {
    public Object buildAll(String modelName, Project project) {
        Task repl;
        ClojureScriptExtension clojurescript;
        HashMap<String, Object> modelData = new HashMap<String, Object>();
        ClojureExtension clojure = (ClojureExtension)project.getExtensions().findByType(ClojureExtension.class);
        if (clojure != null) {
            modelData.put("clojure", clojure.getBuilds());
        }
        if ((clojurescript = (ClojureScriptExtension)project.getExtensions().findByType(ClojureScriptExtension.class)) != null) {
            modelData.put("clojurescript", clojurescript.getBuilds());
        }
        if ((repl = (Task)project.getTasks().findByName("clojureRepl")) != null) {
            HashMap<String, Object> replData = new HashMap<String, Object>();
            replData.put("path", repl.getPath());
            replData.put("dir", repl.getTemporaryDir());
            modelData.put("repl", Edn.keywordize(replData));
        }
        return new ClojurephantModel(Edn.print(Edn.keywordize(modelData)));
    }

    public boolean canBuild(String modelName) {
        return ClojurephantModel.class.getCanonicalName().equals(modelName);
    }
}

