/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.tasks.ClojureTask;
import dev.clojurephant.plugin.common.internal.ClojurephantModelBuilder;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ClojureCommonBasePlugin
implements Plugin<Project> {
    public static final String NREPL_JACK_IN_PROPERTY = "dev.clojurephant.jack-in.nrepl";
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public ClojureCommonBasePlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureJavaToolchain(project);
        this.configureNreplDependencies(project);
        this.registry.register((ToolingModelBuilder)new ClojurephantModelBuilder());
    }

    public void configureJavaToolchain(Project project) {
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        JavaToolchainService javaToolchain = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        Provider launcher = javaToolchain.launcherFor(java.getToolchain());
        project.getTasks().withType(ClojureTask.class, task -> task.getJavaLauncher().set(launcher));
    }

    public void configureNreplDependencies(Project project) {
        Configuration nrepl = (Configuration)project.getConfigurations().create("nrepl");
        if (project.hasProperty(NREPL_JACK_IN_PROPERTY)) {
            String[] jackInDeps;
            for (String jackInDep : jackInDeps = project.findProperty(NREPL_JACK_IN_PROPERTY).toString().split(",")) {
                project.getLogger().lifecycle("Jacking {} into the {} configuration", new Object[]{jackInDep, "nrepl"});
                project.getDependencies().add("nrepl", (Object)jackInDep);
            }
        } else {
            project.getDependencies().add("nrepl", (Object)"nrepl:nrepl:0.9.0");
        }
    }
}

