/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.misc;

import com.strumenta.kotlinmultiplatform.CharsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bJ\u0014\u0010\u0013\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\u0006\u0010\u001a\u001a\u00020\u0011J\u0011\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0013\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0011\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0086\u0002J\b\u0010!\u001a\u00020\u0004H\u0016J\u000e\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0019\u0010$\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010%\u001a\u00020\u0004J\u0006\u0010&\u001a\u00020\u0011J\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020+H\u0016J\u0006\u0010,\u001a\u00020\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006."}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntegerList;", "", "()V", "capacity", "", "(I)V", "list", "(Lorg/antlr/v4/kotlinruntime/misc/IntegerList;)V", "", "(Ljava/util/Collection;)V", "_data", "", "_size", "isEmpty", "", "()Z", "add", "", "value", "addAll", "array", "binarySearch", "key", "fromIndex", "toIndex", "charArraySize", "clear", "contains", "ensureCapacity", "equals", "o", "get", "index", "hashCode", "removeAt", "removeRange", "set", "size", "sort", "toArray", "toCharArray", "", "toString", "", "trimToSize", "Companion", "antlr-kotlin-runtime"})
public class IntegerList {
    private int[] _data;
    private int _size;
    private static final int[] EMPTY_DATA;
    private static final int INITIAL_SIZE;
    private static final int MAX_ARRAY_SIZE;
    public static final Companion Companion;

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final void add(int value) {
        Intrinsics.checkNotNull((Object)this._data);
        if (this._data.length == this._size) {
            this.ensureCapacity(this._size + 1);
        }
        Intrinsics.checkNotNull((Object)this._data);
        this._data[this._size] = value;
        int n = this._size;
        this._size = n + 1;
    }

    public final void addAll(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.ensureCapacity(this._size + array.length);
        Intrinsics.checkNotNull((Object)this._data);
        com.strumenta.kotlinmultiplatform.ArraysKt.arraycopy(array, 0, this._data, this._size, array.length);
        this._size += array.length;
    }

    public final void addAll(@NotNull IntegerList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.ensureCapacity(this._size + list._size);
        Intrinsics.checkNotNull((Object)list._data);
        Intrinsics.checkNotNull((Object)this._data);
        com.strumenta.kotlinmultiplatform.ArraysKt.arraycopy(list._data, 0, this._data, this._size, list._size);
        this._size += list._size;
    }

    /*
     * WARNING - void declaration
     */
    public final void addAll(@NotNull Collection<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.ensureCapacity(this._size + list.size());
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void x;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)this._data);
            this._data[this._size + index] = x;
        }
        this._size += list.size();
    }

    public final int get(int index) {
        if (index < 0 || index >= this._size) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        Intrinsics.checkNotNull((Object)this._data);
        return this._data[index];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(int value) {
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this._data);
            if (this._data[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final int set(int index, int value) {
        if (index < 0 || index >= this._size) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        Intrinsics.checkNotNull((Object)this._data);
        int previous = this._data[index];
        Intrinsics.checkNotNull((Object)this._data);
        this._data[index] = value;
        return previous;
    }

    /*
     * WARNING - void declaration
     */
    public final int removeAt(int index) {
        int value = this.get(index);
        int n = 0;
        int n2 = this._size - index - 1;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this._data);
            Intrinsics.checkNotNull((Object)this._data);
            this._data[index + i] = this._data[index + i + 1];
            ++i;
        }
        Intrinsics.checkNotNull((Object)this._data);
        this._data[this._size - 1] = 0;
        n = this._size;
        this._size = n + -1;
        return value;
    }

    public final void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > this._size || toIndex > this._size) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw (Throwable)new IllegalArgumentException();
        }
        Intrinsics.checkNotNull((Object)this._data);
        Intrinsics.checkNotNull((Object)this._data);
        com.strumenta.kotlinmultiplatform.ArraysKt.arraycopy(this._data, toIndex, this._data, fromIndex, this._size - toIndex);
        this._size -= toIndex - fromIndex;
    }

    public final int size() {
        return this._size;
    }

    public final void trimToSize() {
        Intrinsics.checkNotNull((Object)this._data);
        if (this._data.length == this._size) {
            return;
        }
        Intrinsics.checkNotNull((Object)this._data);
        int[] nArray = this._data;
        int n = this._size;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        this._data = nArray2;
    }

    public final void clear() {
        this._size = 0;
    }

    @NotNull
    public final int[] toArray() {
        int[] nArray;
        if (this._size == 0) {
            nArray = EMPTY_DATA;
        } else {
            Intrinsics.checkNotNull((Object)this._data);
            int[] nArray2 = this._data;
            boolean bl = false;
            int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
            nArray = nArray3;
            Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"java.util.Arrays.copyOf(this, size)");
        }
        return nArray;
    }

    public final void sort() {
        Intrinsics.checkNotNull((Object)this._data);
        ArraysKt.sort((int[])this._data);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegerList)) {
            return false;
        }
        IntegerList other = (IntegerList)o;
        if (this._size != other._size) {
            return false;
        }
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this._data);
            int n3 = this._data[i];
            Intrinsics.checkNotNull((Object)other._data);
            if (n3 != other._data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int hashCode = 1;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this._data);
            hashCode = 31 * hashCode + this._data[i];
            ++i;
        }
        return hashCode;
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default((int[])this.toArray(), null, null, null, (int)0, null, null, (int)63, null);
    }

    public final int binarySearch(int key) {
        Intrinsics.checkNotNull((Object)this._data);
        return ArraysKt.indexOf((int[])this._data, (int)key);
    }

    public final int binarySearch(int fromIndex, int toIndex, int key) {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > this._size || toIndex > this._size) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw (Throwable)new IllegalArgumentException();
        }
        Intrinsics.checkNotNull((Object)this._data);
        int n = fromIndex;
        int i = ArraysKt.indexOf((int[])ArraysKt.sliceArray((int[])this._data, (IntRange)new IntRange(n, toIndex - 1)), (int)key);
        return i == -1 ? -1 : i + fromIndex;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int capacity) {
        Integer[] originalArray;
        int n;
        if (capacity < 0 || capacity > MAX_ARRAY_SIZE) {
            throw (Throwable)new RuntimeException();
        }
        int newLength = 0;
        Intrinsics.checkNotNull((Object)this._data);
        int[] nArray = this._data;
        boolean bl = false;
        if (nArray.length == 0) {
            n = INITIAL_SIZE;
        } else {
            Intrinsics.checkNotNull((Object)this._data);
            n = newLength = this._data.length;
        }
        while (newLength < capacity) {
            if ((newLength *= 2) >= 0 && newLength <= MAX_ARRAY_SIZE) continue;
            newLength = MAX_ARRAY_SIZE;
        }
        Intrinsics.checkNotNull((Object)this._data);
        Integer[] integerArray = originalArray = ArraysKt.toTypedArray((int[])this._data);
        int n2 = 0;
        Object[] objectArray = Arrays.copyOf(integerArray, newLength);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"java.util.Arrays.copyOf(this, newSize)");
        Object[] copiedArray = objectArray;
        int n3 = originalArray.length;
        n2 = copiedArray.length;
        while (n3 < n2) {
            void i;
            copiedArray[i] = 0;
            ++i;
        }
        this._data = CollectionsKt.toIntArray((Collection)ArraysKt.filterNotNull((Object[])copiedArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final char[] toCharArray() {
        char[] resultArray = new char[this._size];
        int resultIdx = 0;
        boolean calculatedPreciseResultSize = false;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this._data);
            int codePoint = this._data[i];
            if (!calculatedPreciseResultSize && CharsKt.isSupplementaryCodePoint(CharCompanionObject.INSTANCE, codePoint)) {
                Character[] characterArray = ArraysKt.toTypedArray((char[])resultArray);
                int n3 = this.charArraySize();
                boolean bl = false;
                Object[] objectArray = Arrays.copyOf(characterArray, n3);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"java.util.Arrays.copyOf(this, newSize)");
                resultArray = CollectionsKt.toCharArray((Collection)ArraysKt.filterNotNull((Object[])objectArray));
                calculatedPreciseResultSize = true;
            }
            int charsWritten = CharsKt.toChars(CharCompanionObject.INSTANCE, codePoint, resultArray, resultIdx);
            resultIdx += charsWritten;
            ++i;
        }
        return resultArray;
    }

    /*
     * WARNING - void declaration
     */
    private final int charArraySize() {
        int result = 0;
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            void i;
            Intrinsics.checkNotNull((Object)this._data);
            result += CharsKt.charCount(CharCompanionObject.INSTANCE, this._data[i]);
            ++i;
        }
        return result;
    }

    public IntegerList() {
        this._data = EMPTY_DATA;
    }

    public IntegerList(int capacity) {
        if (capacity < 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        this._data = capacity == 0 ? EMPTY_DATA : new int[capacity];
    }

    public IntegerList(@NotNull IntegerList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNull((Object)list._data);
        int[] nArray = list._data;
        boolean bl = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        this._data = nArray2;
        this._size = list._size;
    }

    public IntegerList(@NotNull Collection<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this(list.size());
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int value = ((Number)iterator.next()).intValue();
            this.add(value);
        }
    }

    static {
        Companion = new Companion(null);
        EMPTY_DATA = new int[0];
        INITIAL_SIZE = 4;
        MAX_ARRAY_SIZE = 0x7FFFFFF7;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/antlr/v4/kotlinruntime/misc/IntegerList$Companion;", "", "()V", "EMPTY_DATA", "", "INITIAL_SIZE", "", "MAX_ARRAY_SIZE", "antlr-kotlin-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

