/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime.ast;

import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u000bJ\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/antlr/v4/kotlinruntime/ast/Point;", "", "line", "", "column", "(II)V", "getColumn", "()I", "getLine", "advance", "text", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "isBefore", "offset", "code", "toString", "antlr-kotlin-runtime"})
public final class Point {
    private final int line;
    private final int column;

    @NotNull
    public String toString() {
        return "Line " + this.line + ", Column " + this.column;
    }

    /*
     * WARNING - void declaration
     */
    public final int offset(@NotNull String code) {
        void $this$foldRight$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        List lines = StringsKt.split$default((CharSequence)code, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        boolean bl = lines.size() >= this.line;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The point does not exist in the given text. It indicates line " + this.line + " but there are only " + lines.size() + " lines";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = ((String)lines.get(this.line - 1)).length() >= this.column;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "The column does not exist in the given text. Line " + this.line + " has " + ((String)lines.get(this.line - 1)).length() + " columns, the point indicates column " + this.column;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int newLines = this.line - 1;
        List list = lines.subList(0, this.line - 1);
        int initial$iv = 0;
        boolean $i$f$foldRight = false;
        int accumulator$iv = initial$iv;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                void acc;
                int n = accumulator$iv;
                String it = (String)iterator$iv.previous();
                boolean bl6 = false;
                accumulator$iv = it.length() + acc;
            }
        }
        return accumulator$iv + newLines + this.column;
    }

    public final boolean isBefore(@NotNull Point other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.line < other.line || this.line == other.line && this.column < other.column;
    }

    @NotNull
    public final Point advance(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Sequence matches = Regex.findAll$default((Regex)new Regex("\r\n|\r|\n"), (CharSequence)text, (int)0, (int)2, null);
        int line = this.line + SequencesKt.count((Sequence)matches);
        int col = SequencesKt.none((Sequence)matches) ? this.column + text.length() : text.length() - ((MatchResult)SequencesKt.last((Sequence)matches)).getRange().getEndInclusive() - 1;
        return new Point(line, col);
    }

    public final int getLine() {
        return this.line;
    }

    public final int getColumn() {
        return this.column;
    }

    public Point(int line, int column) {
        this.line = line;
        this.column = column;
        boolean bl = this.line >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Line should be equal or greater than 1, was " + this.line;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.column >= 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Column should be equal or greater than 0, was " + this.column;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final int component1() {
        return this.line;
    }

    public final int component2() {
        return this.column;
    }

    @NotNull
    public final Point copy(int line, int column) {
        return new Point(line, column);
    }

    public static /* synthetic */ Point copy$default(Point point, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = point.line;
        }
        if ((n3 & 2) != 0) {
            n2 = point.column;
        }
        return point.copy(n, n2);
    }

    public int hashCode() {
        return this.line * 31 + this.column;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Point)) break block3;
                Point point = (Point)object;
                if (this.line != point.line || this.column != point.column) break block3;
            }
            return true;
        }
        return false;
    }
}

