/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.kotlinruntime;

import com.strumenta.kotlinmultiplatform.LoggingKt;
import com.strumenta.kotlinmultiplatform.Math;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/antlr/v4/kotlinruntime/RuntimeMetaData;", "", "()V", "runtimeVersion", "", "getRuntimeVersion", "()Ljava/lang/String;", "checkVersion", "", "generatingToolVersion", "compileTimeVersion", "getMajorMinorVersion", "version", "antlr-kotlin-runtime"})
public final class RuntimeMetaData {
    @NotNull
    private static final String runtimeVersion;
    public static final RuntimeMetaData INSTANCE;

    @NotNull
    public final String getRuntimeVersion() {
        return runtimeVersion;
    }

    public final void checkVersion(@Nullable String generatingToolVersion, @NotNull String compileTimeVersion) {
        Intrinsics.checkNotNullParameter((Object)compileTimeVersion, (String)"compileTimeVersion");
        String runtimeVersion = RuntimeMetaData.runtimeVersion;
        boolean runtimeConflictsWithGeneratingTool = false;
        boolean runtimeConflictsWithCompileTimeTool = false;
        if (generatingToolVersion != null) {
            runtimeConflictsWithGeneratingTool = Intrinsics.areEqual((Object)runtimeVersion, (Object)generatingToolVersion) ^ true && Intrinsics.areEqual((Object)this.getMajorMinorVersion(runtimeVersion), (Object)this.getMajorMinorVersion(generatingToolVersion)) ^ true;
        }
        boolean bl = runtimeConflictsWithCompileTimeTool = Intrinsics.areEqual((Object)runtimeVersion, (Object)compileTimeVersion) ^ true && Intrinsics.areEqual((Object)this.getMajorMinorVersion(runtimeVersion), (Object)this.getMajorMinorVersion(compileTimeVersion)) ^ true;
        if (runtimeConflictsWithGeneratingTool) {
            LoggingKt.errMessage("ANTLR Tool version " + generatingToolVersion + " used for code generation does not match the current runtime version " + runtimeVersion);
        }
        if (runtimeConflictsWithCompileTimeTool) {
            LoggingKt.errMessage("ANTLR Runtime version " + compileTimeVersion + " used for parser compilation does not match the current runtime version " + runtimeVersion);
        }
    }

    @NotNull
    public final String getMajorMinorVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        int firstDot = StringsKt.indexOf$default((CharSequence)version, (char)'.', (int)0, (boolean)false, (int)6, null);
        int secondDot = firstDot >= 0 ? StringsKt.indexOf$default((CharSequence)version, (char)'.', (int)(firstDot + 1), (boolean)false, (int)4, null) : -1;
        int firstDash = StringsKt.indexOf$default((CharSequence)version, (char)'-', (int)0, (boolean)false, (int)6, null);
        int referenceLength = version.length();
        if (secondDot >= 0) {
            referenceLength = Math.INSTANCE.min(referenceLength, secondDot);
        }
        if (firstDash >= 0) {
            referenceLength = Math.INSTANCE.min(referenceLength, firstDash);
        }
        String string = version;
        int n = 0;
        boolean bl = false;
        String string2 = string.substring(n, referenceLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private RuntimeMetaData() {
    }

    static {
        RuntimeMetaData runtimeMetaData;
        INSTANCE = runtimeMetaData = new RuntimeMetaData();
        runtimeVersion = "4.7.1";
    }
}

